/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.multithreading;

import com.austinv11.collectiveframework.multithreading.ICalculations;
import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import com.austinv11.collectiveframework.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HeavyCalculations {
    private static int calculationNumber = 0;
    private List<CalculationThread> threads = new ArrayList<CalculationThread>();
    private ConcurrentHashMap<ICalculations, Future> futures = new ConcurrentHashMap();
    private boolean isKill = false;

    public HeavyCalculations(int numberOfThreads) {
        for (int i = 0; i < numberOfThreads; ++i) {
            this.threads.add(new CalculationThread());
        }
    }

    private void removeCalculation(ICalculations calculations) {
        for (CalculationThread thread : this.threads) {
            if (!thread.calculations.contains(calculations)) continue;
            thread.calculations.remove(calculations);
            return;
        }
    }

    private void delegate(ICalculations calculations) {
        int minCalculations = -1;
        CalculationThread thread = null;
        for (CalculationThread thread1 : this.threads) {
            if (minCalculations != -1 && minCalculations <= thread1.calculations.size()) continue;
            minCalculations = thread1.calculations.size();
            thread = thread1;
        }
        thread.calculations.add(calculations);
    }

    public <T> Future<T> addCalculation(T calculation) {
        ICalculations calculations = (ICalculations)calculation;
        this.delegate(calculations);
        FutureImpl future = new FutureImpl(calculations, calculation);
        this.futures.put(calculations, future);
        return future;
    }

    public <T> Future<T> addCalculation(T calculation, String methodToCalculate, Object ... params) {
        ICalculationsWrapper calculations = new ICalculationsWrapper(calculation, methodToCalculate, params);
        this.delegate(calculations);
        FutureImpl future = new FutureImpl(calculations, calculation);
        this.futures.put(calculations, future);
        return future;
    }

    public Future<ICalculations> addCalculation(Class calculationClass, String methodToCalculate, Object ... params) {
        ICalculationsWrapper calculations = new ICalculationsWrapper(calculationClass, methodToCalculate, params);
        this.delegate(calculations);
        FutureImpl<ICalculations> future = new FutureImpl<ICalculations>(calculations, null);
        this.futures.put(calculations, future);
        return future;
    }

    public void kill() {
        for (CalculationThread thread : this.threads) {
            thread.disable(true);
        }
        this.isKill = true;
    }

    public boolean isDead() {
        return this.isKill;
    }

    private class FutureImpl<V>
    implements Future<V> {
        private volatile ICalculations calculations;
        private Object object;
        private boolean isCancelled = false;
        public volatile boolean isDone = false;

        public FutureImpl(ICalculations calculations, Object object) {
            this.calculations = calculations;
            this.object = object;
        }

        public void setDone() {
            this.isDone = true;
            HeavyCalculations.this.futures.remove(this.calculations);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            HeavyCalculations.this.removeCalculation(this.calculations);
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            while (!this.isDone) {
            }
            if (this.object != null) {
                return (V)this.object;
            }
            return null;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            for (timeout = unit.toMillis(timeout); !this.isDone && timeout > 0L; --timeout) {
                this.wait(1L);
            }
            if (this.object != null) {
                return (V)this.object;
            }
            return null;
        }
    }

    private class ICalculationsWrapper
    implements ICalculations {
        private Object object;
        private String methodName;
        private Object[] params;

        public ICalculationsWrapper(Object object, String methodName, Object[] params) {
            this.object = object;
            this.methodName = methodName;
            this.params = params;
        }

        @Override
        public void doCalculation() {
            try {
                Method m = this.object instanceof Class ? ReflectionUtils.getDeclaredOrNormalMethod(this.methodName, (Class)this.object) : ReflectionUtils.getDeclaredOrNormalMethod(this.methodName, this.object.getClass());
                m.invoke(this.object instanceof Class ? null : this.object, this.params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class CalculationThread
    extends SimpleRunnable {
        private int id;
        public ConcurrentLinkedDeque<ICalculations> calculations = new ConcurrentLinkedDeque();

        public CalculationThread() {
            this.id = calculationNumber++;
            this.start();
        }

        @Override
        public void run() {
            if (!this.calculations.isEmpty()) {
                ICalculations calculation = this.calculations.pop();
                calculation.doCalculation();
                ((FutureImpl)HeavyCalculations.this.futures.get(calculation)).setDone();
            }
        }

        @Override
        public String getName() {
            return "Calculation Thread #" + this.id;
        }
    }
}

