/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NBTHelper {
    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.field_77990_d != null) {
            itemStack.field_77990_d.func_82580_o(keyName);
        }
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static long getLong(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setLong(itemStack, keyName, 0L);
        }
        return itemStack.field_77990_d.func_74763_f(keyName);
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74772_a(keyName, keyValue);
    }

    public static String getString(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setString(itemStack, keyName, "");
        }
        return itemStack.field_77990_d.func_74779_i(keyName);
    }

    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74778_a(keyName, keyValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setBoolean(itemStack, keyName, false);
        }
        return itemStack.field_77990_d.func_74767_n(keyName);
    }

    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74757_a(keyName, keyValue);
    }

    public static byte getByte(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setByte(itemStack, keyName, (byte)0);
        }
        return itemStack.field_77990_d.func_74771_c(keyName);
    }

    public static void setByte(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74774_a(keyName, keyValue);
    }

    public static short getShort(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setShort(itemStack, keyName, (short)0);
        }
        return itemStack.field_77990_d.func_74765_d(keyName);
    }

    public static void setShort(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74777_a(keyName, keyValue);
    }

    public static int getInt(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setInteger(itemStack, keyName, 0);
        }
        return itemStack.field_77990_d.func_74762_e(keyName);
    }

    public static void setInteger(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74768_a(keyName, keyValue);
    }

    public static float getFloat(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setFloat(itemStack, keyName, 0.0f);
        }
        return itemStack.field_77990_d.func_74760_g(keyName);
    }

    public static void setFloat(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74776_a(keyName, keyValue);
    }

    public static double getDouble(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setDouble(itemStack, keyName, 0.0);
        }
        return itemStack.field_77990_d.func_74769_h(keyName);
    }

    public static void setDouble(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74780_a(keyName, keyValue);
    }

    public static NBTTagList getList(ItemStack itemStack, String keyName, int type) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.field_77990_d.func_74764_b(keyName)) {
            NBTHelper.setList(itemStack, keyName, new NBTTagList());
        }
        return itemStack.field_77990_d.func_150295_c(keyName, type);
    }

    public static void setList(ItemStack itemStack, String keyName, NBTTagList tag) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74782_a(keyName, (NBTBase)tag);
    }

    public static void addInfo(ItemStack itemStack, List<String> text) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (NBTHelper.hasTag(itemStack, "display")) {
            NBTTagCompound display = itemStack.field_77990_d.func_74775_l("display");
            NBTTagList list = display.func_150295_c("Lore", 8);
            for (String s : text) {
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            display.func_74782_a("Lore", (NBTBase)list);
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)display);
        } else {
            NBTTagCompound display = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (String s : text) {
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            display.func_74782_a("Lore", (NBTBase)list);
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)display);
        }
    }

    public static void setInfo(ItemStack itemStack, List<String> text) {
        NBTHelper.initNBTTagCompound(itemStack);
        NBTTagCompound display = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (String s : text) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        display.func_74782_a("Lore", (NBTBase)list);
        itemStack.field_77990_d.func_74782_a("display", (NBTBase)display);
    }

    public static void removeInfo(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "display")) {
            NBTTagCompound display = itemStack.field_77990_d.func_74775_l("display");
            display.func_82580_o("Lore");
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)display);
        }
    }

    public static void setTag(ItemStack itemStack, String keyName, NBTBase tag) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74782_a(keyName, tag);
    }

    public static NBTBase getTag(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        return itemStack.field_77990_d.func_74781_a(keyName);
    }

    public static void setIntArray(ItemStack itemStack, String keyName, int[] array) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74783_a(keyName, array);
    }

    public static int[] getIntArray(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        return itemStack.field_77990_d.func_74759_k(keyName);
    }

    public static void setCompoundTag(ItemStack itemStack, String keyName, NBTTagCompound tag) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74782_a(keyName, (NBTBase)tag);
    }

    public static NBTTagCompound getCompoundTag(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        return itemStack.field_77990_d.func_74775_l(keyName);
    }
}

