/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.books.simple;

import com.austinv11.collectiveframework.minecraft.books.api.Entry;
import com.austinv11.collectiveframework.minecraft.utils.client.GuiUtils;
import com.austinv11.collectiveframework.utils.math.Ratio;
import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ImageEntry
extends Entry {
    public boolean scaleToSize = true;
    public boolean retainRatio = true;
    private ResourceLocation image;
    private Ratio ratio;

    public ImageEntry(TwoDimensionalVector coords, int width, int height, ResourceLocation image) throws IOException {
        this(coords, width, height);
        this.image = image;
        BufferedImage backgroundImage = ImageIO.read(GuiUtils.getResourceAsStream(image));
        int backgroundWidth = backgroundImage.getWidth();
        int backgroundHeight = backgroundImage.getHeight();
        this.ratio = new Ratio(backgroundWidth, backgroundHeight);
    }

    private ImageEntry(TwoDimensionalVector coords, int width, int height) {
        super(coords, width, height);
    }

    @Override
    public void onRender(int dt) {
        GL11.glPushMatrix();
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (this.scaleToSize) {
            double[] ratio = this.ratio.getOriginalRatio();
            int width = (int)ratio[0];
            int height = (int)ratio[1];
            if (this.retainRatio) {
                scaleX = (double)this.field_146294_l / (double)width;
                scaleY = (double)this.field_146295_m / (double)height;
                double valueToScale = scaleX < scaleY ? scaleX : scaleY;
                GL11.glScaled((double)valueToScale, (double)valueToScale, (double)1.0);
            } else {
                scaleX = (double)this.field_146294_l / (double)width;
                scaleY = (double)this.field_146295_m / (double)height;
                GL11.glScaled((double)scaleX, (double)scaleY, (double)1.0);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        this.func_73729_b(this.getCoords().getRoundedX(), this.getCoords().getRoundedY(), 0, 0, (int)((double)this.field_146294_l * (1.0 / scaleX)), (int)((double)this.field_146295_m * (1.0 / scaleY)));
        GL11.glPopMatrix();
    }
}

