/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.asm;

import com.austinv11.collectiveframework.dependencies.download.BinaryProvider;
import com.austinv11.collectiveframework.dependencies.download.FileType;
import com.austinv11.collectiveframework.dependencies.download.PlainTextProvider;
import com.austinv11.collectiveframework.minecraft.CollectiveFramework;
import com.austinv11.collectiveframework.minecraft.asm.CollectiveFrameworkTransformerPlugin;
import com.austinv11.collectiveframework.utils.FileUtils;
import com.austinv11.collectiveframework.utils.StringUtils;
import com.austinv11.collectiveframework.utils.WebUtils;
import com.google.gson.Gson;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@IFMLLoadingPlugin.SortingIndex(value=-2147483648)
public class CollectiveFrameworkEarlyTransformerPlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static boolean didInject = false;

    public CollectiveFrameworkEarlyTransformerPlugin() {
        if (!didInject) {
            try {
                FMLLog.log((String)"CollectiveFramework Early-Init", (Level)Level.INFO, (String)"Injecting transformer...", (Object[])new Object[0]);
                this.injectNewTransformer();
            }
            catch (Exception e) {
                FMLLog.log((String)"CollectiveFramework Early-Init", (Level)Level.FATAL, (String)"There was a problem injecting the CollectiveFramework ASM Transformer!", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    private void injectNewTransformer() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> e = Class.forName("cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper");
        Constructor<?> wrapperConstructor = e.getConstructor(String.class, IFMLLoadingPlugin.class, File.class, Integer.TYPE, String[].class);
        Field loadPlugins = CoreModManager.class.getDeclaredField("loadPlugins");
        wrapperConstructor.setAccessible(true);
        loadPlugins.setAccessible(true);
        ((List)loadPlugins.get(null)).add(wrapperConstructor.newInstance("CollectiveFrameworkPlugin", new CollectiveFrameworkTransformerPlugin(), null, Integer.MAX_VALUE, new String[0]));
        didInject = true;
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "com.austinv11.collectiveframework.minecraft.asm.DummyContainer";
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return "com.austinv11.collectiveframework.minecraft.asm.CollectiveFrameworkAccessTransformer";
    }

    public Void call() throws Exception {
        ModpackProvider provider = new ModpackProvider();
        File xml = new File("modpack.xml");
        if (xml.exists()) {
            FMLLog.log((String)"CollectiveFramework Early-Init", (Level)Level.INFO, (String)"modpack.xml found! Installing modpack...", (Object[])new Object[0]);
            FMLLog.log((String)"CollectiveFramework Early-Init", (Level)Level.INFO, (String)"Do NOT stop the client if it hangs!", (Object[])new Object[0]);
            provider.installMods(provider.parseModpackXML(xml), provider.doOverwrite(xml));
            FMLLog.log((String)"CollectiveFramework Early-Init", (Level)Level.INFO, (String)"Modpack installed! Restarting Minecraft is recommended (though not required)", (Object[])new Object[0]);
        }
        return null;
    }

    public static class ModpackProvider {
        private static String lastVersion;
        private String version;

        public boolean doOverwrite(File xmlFile) throws ParserConfigurationException, IOException, SAXException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            return doc.getDocumentElement().hasAttribute("overwrite") && Boolean.parseBoolean(doc.getDocumentElement().getAttribute("overwrite")) || doc.getDocumentElement().hasAttribute("version") && !doc.getDocumentElement().hasAttribute("overwrite") && !this.getLastVersion().equals(doc.getDocumentElement().getAttribute("version"));
        }

        public String getLastVersion() {
            return lastVersion;
        }

        public String getVersion() {
            return this.version;
        }

        public List<IModpackFile> parseModpackXML(File xmlFile) throws ParserConfigurationException, IOException, SAXException {
            String fileName;
            ArrayList<IModpackFile> mods = new ArrayList<IModpackFile>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            this.version = doc.getDocumentElement().hasAttribute("version") ? doc.getDocumentElement().getAttribute("version") : "NULL";
            NodeList curseNodeList = doc.getElementsByTagName("cursemod");
            CollectiveFramework.LOGGER.info(curseNodeList.getLength() + " Curse mod(s) found!");
            for (int i = 0; i < curseNodeList.getLength(); ++i) {
                Node node = curseNodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("id");
                String slug = element.getElementsByTagName("slug").item(0).getTextContent();
                String mcversion = element.getElementsByTagName("mcversion").getLength() > 0 ? element.getElementsByTagName("mcversion").item(0).getTextContent() : "1.7.10";
                ReleaseType releaseType = element.getElementsByTagName("releasetype").getLength() > 0 ? ReleaseType.fromString(element.getElementsByTagName("releasetype").item(0).getTextContent()) : ReleaseType.RELEASE;
                int id = element.getElementsByTagName("id").getLength() > 0 ? Integer.valueOf(element.getElementsByTagName("id").item(0).getTextContent()) : -1;
                fileName = element.getElementsByTagName("name").getLength() > 0 ? element.getElementsByTagName("name").item(0).getTextContent() : "@REPLACE@";
                mods.add(new CurseMod(name, slug, mcversion, releaseType, id, fileName));
            }
            NodeList adflyNodeList = doc.getElementsByTagName("adflymod");
            CollectiveFramework.LOGGER.info(adflyNodeList.getLength() + " Adfly-type mod(s) found!");
            for (int i = 0; i < adflyNodeList.getLength(); ++i) {
                Node node = adflyNodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("id");
                String link = element.getElementsByTagName("link").item(0).getTextContent();
                String fileName2 = element.getElementsByTagName("name").item(0).getTextContent();
                mods.add(new AdflyMod(name, link, fileName2));
            }
            NodeList modNodeList = doc.getElementsByTagName("mod");
            CollectiveFramework.LOGGER.info(modNodeList.getLength() + " Other mod(s) found!");
            for (int i = 0; i < modNodeList.getLength(); ++i) {
                Node node = modNodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("id");
                String link = element.getElementsByTagName("link").item(0).getTextContent();
                String fileName3 = element.getElementsByTagName("name").item(0).getTextContent();
                mods.add(new OtherMod(name, link, fileName3));
            }
            NodeList plainNodeList = doc.getElementsByTagName("plainfile");
            CollectiveFramework.LOGGER.info(plainNodeList.getLength() + " Other plain file(s) found!");
            for (int i = 0; i < plainNodeList.getLength(); ++i) {
                Node node = plainNodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("id");
                String link = element.getElementsByTagName("link").item(0).getTextContent();
                fileName = element.getElementsByTagName("path").item(0).getTextContent();
                mods.add(new OtherFile(name, link, fileName, FileType.PLAIN_TEXT));
            }
            NodeList binaryNodeList = doc.getElementsByTagName("binaryfile");
            CollectiveFramework.LOGGER.info(binaryNodeList.getLength() + " Other binary file(s) found!");
            for (int i = 0; i < binaryNodeList.getLength(); ++i) {
                Node node = binaryNodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("id");
                String link = element.getElementsByTagName("link").item(0).getTextContent();
                String fileName4 = element.getElementsByTagName("path").item(0).getTextContent();
                mods.add(new OtherFile(name, link, fileName4, FileType.BINARY));
            }
            NodeList zipNodeList = doc.getElementsByTagName("zipfile");
            CollectiveFramework.LOGGER.info(zipNodeList.getLength() + " Zip file(s) found!");
            for (int i = 0; i < zipNodeList.getLength(); ++i) {
                Node node = zipNodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("id");
                String link = element.getElementsByTagName("link").item(0).getTextContent();
                String fileName5 = element.getElementsByTagName("path").item(0).getTextContent();
                mods.add(new ZipFile(name, link, fileName5));
            }
            return mods;
        }

        public void installMods(List<IModpackFile> mods, boolean overwrite) throws IOException {
            for (IModpackFile mod : mods) {
                boolean didDownload;
                CollectiveFramework.LOGGER.info("Installing " + mod.getType() + " '" + mod.getName() + "'...");
                if (new File(ModpackProvider.formatPath(mod.getPath())).exists() && !overwrite) {
                    CollectiveFramework.LOGGER.info("Skipping " + mod.getType() + " '" + mod.getName() + "', it already exists!");
                }
                if (didDownload = mod.install()) {
                    CollectiveFramework.LOGGER.info("Installed " + mod.getType() + " '" + mod.getName() + "'!");
                    continue;
                }
                CollectiveFramework.LOGGER.warn("Failed to install " + mod.getType() + " '" + mod.getName() + "'!");
            }
            File changelog = new File("Modpack.log");
            if (!changelog.exists()) {
                changelog.createNewFile();
            }
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            FileUtils.safeWrite(changelog, format.format(new Date()) + "\n" + this.getVersion());
        }

        protected static String formatPath(String path) {
            if (path.contains("./") && path.startsWith("./")) {
                return path;
            }
            return "./" + path;
        }

        static {
            File changelog = new File("Modpack.log");
            if (!changelog.exists()) {
                lastVersion = "NULL";
            } else {
                try {
                    List<String> log = FileUtils.readAll(changelog);
                    lastVersion = log.get(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static class JSONCurseResponse {
            String name;
            String game;
            String category;
            String url;
            String thumbnail;
            String[] authors;
            JSONDownloads downloads;
            int favorites;
            int likes;
            String updated_at;
            String created_at;
            String project_url;
            String release_type;
            String license;
            JSONDownload download;
            Map<String, JSONDownload[]> versions;
            Map<String, JSONDownload> files;

            public static class JSONDownload {
                int id;
                String url;
                String name;
                String type;
                String version;
                String downloads;
                String created_at;
            }

            public static class JSONDownloads {
                int monthly;
                int total;
            }
        }

        public static enum ReleaseType {
            RELEASE,
            BETA,
            ALPHA;


            public static ReleaseType fromString(String s) {
                if (s != null) {
                    if (s.equalsIgnoreCase("beta")) {
                        return BETA;
                    }
                    if (s.equalsIgnoreCase("alpha")) {
                        return ALPHA;
                    }
                }
                return RELEASE;
            }
        }

        public static class CurseMod
        implements IModpackFile {
            public String name;
            public String slug;
            public String mcversion;
            public ReleaseType releasetype;
            public int id;
            public String fileName;
            public JSONCurseResponse curseResponse;
            public String url;

            public CurseMod(String name, String slug, String mcversion, ReleaseType releaseType, int id, String fileName) {
                this.name = name;
                this.slug = slug;
                this.mcversion = mcversion;
                this.releasetype = releaseType;
                this.id = id;
                this.fileName = fileName;
                this.parseCurseJson();
                if (id != -1) {
                    this.url = "http://minecraft.curseforge.com/mc-mods/" + slug + "/files/" + id + "/download";
                } else {
                    for (JSONCurseResponse.JSONDownload download : this.curseResponse.versions.get(mcversion)) {
                        if (!download.version.equalsIgnoreCase(mcversion)) continue;
                        this.url = "http://minecraft.curseforge.com/mc-mods/" + slug + "/files/" + download.id + "/download";
                        break;
                    }
                }
                if (fileName.equals("@REPLACE@")) {
                    fileName = this.curseResponse.files.get((Object)new StringBuilder().append((int)id).append((String)"").toString()).name;
                }
            }

            public void parseCurseJson() {
                Gson gson = new Gson();
                try {
                    this.curseResponse = (JSONCurseResponse)gson.fromJson(StringUtils.stringFromList(WebUtils.readURL("http://widget.mcf.li/mc-mods/minecraft/" + this.slug + ".json")), JSONCurseResponse.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean install() {
                return new BinaryProvider().downloadFile(this.url, this.getPath());
            }

            @Override
            public String getType() {
                return "curse mod";
            }

            @Override
            public String getPath() {
                return "./mods/" + this.fileName;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static class AdflyMod
        implements IModpackFile {
            public String name;
            public String url;
            public String fileName;

            public AdflyMod(String name, String url, String fileName) {
                this.name = name;
                this.url = url;
                this.fileName = fileName;
            }

            @Override
            public boolean install() {
                CollectiveFramework.LOGGER.info("Redirecting you to " + this.url);
                try {
                    Desktop.getDesktop().browse(new URI(this.url));
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileNameExtensionFilter("Mod files", "jar", "zip"));
                    fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                    int result = fileChooser.showOpenDialog(null);
                    if (result == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        return selectedFile.renameTo(new File(this.getPath()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }

            @Override
            public String getType() {
                return "adfly mod";
            }

            @Override
            public String getPath() {
                return "./mods/" + this.fileName;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static class OtherMod
        implements IModpackFile {
            public String name;
            public String url;
            public String fileName;

            public OtherMod(String name, String url, String fileName) {
                this.name = name;
                this.url = url;
                this.fileName = fileName;
            }

            @Override
            public boolean install() {
                return new BinaryProvider().downloadFile(this.url, this.getPath());
            }

            @Override
            public String getType() {
                return "mod";
            }

            @Override
            public String getPath() {
                return "./mods/" + this.fileName;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static class OtherFile
        implements IModpackFile {
            public String name;
            public String url;
            public String fileName;
            public FileType type;

            public OtherFile(String name, String url, String fileName, FileType type) {
                this.name = name;
                this.url = url;
                this.fileName = ModpackProvider.formatPath(fileName);
                this.type = type;
            }

            @Override
            public boolean install() {
                if (this.type == FileType.BINARY) {
                    return new BinaryProvider().downloadFile(this.url, this.getPath());
                }
                if (this.type == FileType.PLAIN_TEXT) {
                    return new PlainTextProvider().downloadFile(this.url, this.getPath());
                }
                return false;
            }

            @Override
            public String getType() {
                return "file";
            }

            @Override
            public String getPath() {
                return this.fileName;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static class ZipFile
        implements IModpackFile {
            public String name;
            public String url;
            public String fileName;

            public ZipFile(String name, String url, String fileName) {
                this.name = name;
                this.url = url;
                this.fileName = ModpackProvider.formatPath(fileName);
            }

            @Override
            public boolean install() {
                File temp = new File(this.getPath() + File.separator + "temp.zip");
                boolean result = new BinaryProvider().downloadFile(this.url, temp.getPath());
                if (!result) {
                    return false;
                }
                try {
                    FileUtils.unzip(temp, new File(this.getPath()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                temp.delete();
                return true;
            }

            @Override
            public String getType() {
                return "zip";
            }

            @Override
            public String getPath() {
                return this.fileName;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static interface IModpackFile {
            public boolean install();

            public String getType();

            public String getPath();

            public String getName();
        }
    }
}

