/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.forestry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAllelePlantType;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IIndividualLiving;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.driver.Converter;

public class ConverterIIndividual
implements Converter {
    private static final GenomeAccess ACTIVE = new GenomeAccess(){

        @Override
        protected IAllele getAllele(IChromosome chromosome) {
            return chromosome.getActiveAllele();
        }
    };
    private static final GenomeAccess INACTIVE = new GenomeAccess(){

        @Override
        protected IAllele getAllele(IChromosome chromosome) {
            return chromosome.getInactiveAllele();
        }
    };
    private static final Map<Class<? extends IAllele>, IAlleleConverter<?>> converters = ImmutableMap.builder().put(IAlleleFloat.class, (Object)new IAlleleConverter<IAlleleFloat>(){

        @Override
        public Object convert(IAlleleFloat allele) {
            return Float.valueOf(allele.getValue());
        }
    }).put(IAlleleInteger.class, (Object)new IAlleleConverter<IAlleleInteger>(){

        @Override
        public Object convert(IAlleleInteger allele) {
            return allele.getValue();
        }
    }).put(IAlleleBoolean.class, (Object)new IAlleleConverter<IAlleleBoolean>(){

        @Override
        public Object convert(IAlleleBoolean allele) {
            return allele.getValue();
        }
    }).put(IAlleleArea.class, (Object)new IAlleleConverter<IAlleleArea>(){

        @Override
        public Object convert(IAlleleArea allele) {
            return allele.getValue();
        }
    }).put(IAllelePlantType.class, (Object)new IAlleleConverter<IAllelePlantType>(){

        @Override
        public Object convert(IAllelePlantType allele) {
            return allele.getPlantTypes();
        }
    }).put(IAlleleGrowth.class, (Object)new IAlleleConverter<IAlleleGrowth>(){

        @Override
        public Object convert(IAlleleGrowth allele) {
            return allele.getProvider().getInfo();
        }
    }).build();

    @Override
    public void convert(Object value, Map<Object, Object> output) {
        if (value instanceof IIndividual) {
            IIndividual individual = (IIndividual)value;
            output.put("displayName", individual.getDisplayName());
            output.put("ident", individual.getIdent());
            boolean isAnalyzed = individual.isAnalyzed();
            output.put("isAnalyzed", isAnalyzed);
            output.put("isSecret", individual.isSecret());
            GenomeReader genomeReader = null;
            if (individual instanceof IIndividualLiving) {
                IIndividualLiving living = (IIndividualLiving)individual;
                output.put("health", living.getHealth());
                output.put("maxHealth", living.getMaxHealth());
            }
            if (individual instanceof IBee) {
                IBee bee = (IBee)individual;
                output.put("type", "bee");
                output.put("canSpawn", bee.canSpawn());
                output.put("generation", bee.getGeneration());
                output.put("hasEffect", bee.hasEffect());
                output.put("isAlive", bee.isAlive());
                output.put("isNatural", bee.isNatural());
                if (isAnalyzed) {
                    genomeReader = new BeeGenomeReader(bee.getGenome());
                }
            } else if (individual instanceof IButterfly) {
                IButterfly butterfly = (IButterfly)individual;
                output.put("type", "butterfly");
                output.put("size", Float.valueOf(butterfly.getSize()));
                if (isAnalyzed) {
                    genomeReader = new ButterflyGenomeReader(butterfly.getGenome());
                }
            } else if (individual instanceof ITree) {
                ITree tree = (ITree)individual;
                output.put("type", "tree");
                output.put("plantType", tree.getPlantTypes().toString());
                if (isAnalyzed) {
                    genomeReader = new TreeGenomeReader(tree.getGenome());
                }
            }
            if (genomeReader != null) {
                output.put("active", genomeReader.getActiveInfo());
                output.put("inactive", genomeReader.getInactiveInfo());
            }
        }
    }

    private static class TreeGenomeReader
    extends GenomeReader<ITreeGenome, EnumTreeChromosome> {
        public TreeGenomeReader(ITreeGenome genome) {
            super(genome);
        }

        @Override
        protected void addAlleleInfo(GenomeAccess access, Map<String, Object> result2) {
            result2.put("species", this.convertAllele(access, IAlleleTreeSpecies.class, EnumTreeChromosome.SPECIES));
            result2.put("growth", this.convertAllele(access, IAlleleGrowth.class, EnumTreeChromosome.GROWTH));
            result2.put("height", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.HEIGHT));
            result2.put("fertility", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.FERTILITY));
            result2.put("fruits", this.convertAllele(access, IAlleleFruit.class, EnumTreeChromosome.FRUITS));
            result2.put("yield", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.YIELD));
            result2.put("plant", this.convertAllele(access, IAllelePlantType.class, EnumTreeChromosome.PLANT));
            result2.put("sappiness", this.convertAllele(access, IAlleleFloat.class, EnumTreeChromosome.SAPPINESS));
            result2.put("territory", this.convertAllele(access, IAlleleArea.class, EnumTreeChromosome.TERRITORY));
            result2.put("effect", this.convertAllele(access, IAlleleLeafEffect.class, EnumTreeChromosome.EFFECT));
            result2.put("maturation", this.convertAllele(access, IAlleleInteger.class, EnumTreeChromosome.MATURATION));
            result2.put("girth", this.convertAllele(access, IAlleleInteger.class, EnumTreeChromosome.GIRTH));
        }
    }

    private static class ButterflyGenomeReader
    extends GenomeReader<IButterflyGenome, EnumButterflyChromosome> {
        public ButterflyGenomeReader(IButterflyGenome genome) {
            super(genome);
        }

        @Override
        protected void addAlleleInfo(GenomeAccess access, Map<String, Object> result2) {
            result2.put("species", this.convertAllele(access, IAlleleButterflySpecies.class, EnumButterflyChromosome.SPECIES));
            result2.put("size", this.convertAllele(access, IAlleleFloat.class, EnumButterflyChromosome.SIZE));
            result2.put("speed", this.convertAllele(access, IAlleleFloat.class, EnumButterflyChromosome.SPEED));
            result2.put("lifespan", this.convertAllele(access, IAlleleInteger.class, EnumButterflyChromosome.LIFESPAN));
            result2.put("metabolism", this.convertAllele(access, IAlleleInteger.class, EnumButterflyChromosome.METABOLISM));
            result2.put("fertility", this.convertAllele(access, IAlleleInteger.class, EnumButterflyChromosome.FERTILITY));
            result2.put("temperatureTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumButterflyChromosome.TEMPERATURE_TOLERANCE));
            result2.put("humidityTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumButterflyChromosome.HUMIDITY_TOLERANCE));
            result2.put("nocturnal", this.convertAllele(access, IAlleleBoolean.class, EnumButterflyChromosome.NOCTURNAL));
            result2.put("tolerantFlyer", this.convertAllele(access, IAlleleBoolean.class, EnumButterflyChromosome.TOLERANT_FLYER));
            result2.put("fireResist", this.convertAllele(access, IAlleleBoolean.class, EnumButterflyChromosome.FIRE_RESIST));
            result2.put("flowerProvider", this.convertAllele(access, IAlleleFlowers.class, EnumButterflyChromosome.FLOWER_PROVIDER));
            result2.put("effect", this.convertAllele(access, IAlleleButterflyEffect.class, EnumButterflyChromosome.EFFECT));
            result2.put("territory", this.convertAllele(access, IAlleleArea.class, EnumButterflyChromosome.TERRITORY));
        }
    }

    private static class BeeGenomeReader
    extends GenomeReader<IBeeGenome, EnumBeeChromosome> {
        public BeeGenomeReader(IBeeGenome genome) {
            super(genome);
        }

        @Override
        protected void addAlleleInfo(GenomeAccess access, Map<String, Object> result2) {
            result2.put("species", this.convertAllele(access, IAlleleBeeSpecies.class, EnumBeeChromosome.SPECIES));
            result2.put("speed", this.convertAllele(access, IAlleleFloat.class, EnumBeeChromosome.SPEED));
            result2.put("lifespan", this.convertAllele(access, IAlleleInteger.class, EnumBeeChromosome.LIFESPAN));
            result2.put("fertility", this.convertAllele(access, IAlleleInteger.class, EnumBeeChromosome.FERTILITY));
            result2.put("temperatureTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumBeeChromosome.TEMPERATURE_TOLERANCE));
            result2.put("nocturnal", this.convertAllele(access, IAlleleBoolean.class, EnumBeeChromosome.NOCTURNAL));
            result2.put("humidityTolerance", this.convertAllele(access, IAlleleTolerance.class, EnumBeeChromosome.HUMIDITY_TOLERANCE));
            result2.put("tolerantFlyer", this.convertAllele(access, IAlleleBoolean.class, EnumBeeChromosome.TOLERANT_FLYER));
            result2.put("caveDwelling", this.convertAllele(access, IAlleleBoolean.class, EnumBeeChromosome.CAVE_DWELLING));
            result2.put("flowerProvider", this.convertAllele(access, IAlleleFlowers.class, EnumBeeChromosome.FLOWER_PROVIDER));
            result2.put("flowering", this.convertAllele(access, IAlleleInteger.class, EnumBeeChromosome.FLOWERING));
            result2.put("effect", this.convertAllele(access, IAlleleBeeEffect.class, EnumBeeChromosome.EFFECT));
            result2.put("territory", this.convertAllele(access, IAlleleArea.class, EnumBeeChromosome.TERRITORY));
        }
    }

    private static abstract class GenomeReader<G extends IGenome, E extends Enum<E>> {
        private final G genome;

        public GenomeReader(G genome) {
            this.genome = genome;
        }

        protected <A extends IAllele> A getAllele(GenomeAccess access, Class<A> cls, E chromosome) {
            Preconditions.checkArgument((((IChromosomeType)chromosome).getAlleleClass() == cls ? 1 : 0) != 0);
            IAllele allele = access.getAllele((IGenome)this.genome, ((Enum)chromosome).ordinal());
            return (A)allele;
        }

        protected <A extends IAllele> Object convertAllele(GenomeAccess access, Class<A> cls, E chromosome) {
            A allele = this.getAllele(access, cls, chromosome);
            if (allele == null) {
                return "missing";
            }
            IAlleleConverter converter = (IAlleleConverter)converters.get(cls);
            return converter != null ? converter.convert(allele) : allele.getName();
        }

        protected abstract void addAlleleInfo(GenomeAccess var1, Map<String, Object> var2);

        public Map<String, Object> getActiveInfo() {
            HashMap result2 = Maps.newHashMap();
            this.addAlleleInfo(ACTIVE, result2);
            return result2;
        }

        public Map<String, Object> getInactiveInfo() {
            HashMap result2 = Maps.newHashMap();
            this.addAlleleInfo(INACTIVE, result2);
            return result2;
        }
    }

    private static interface IAlleleConverter<A extends IAllele> {
        public Object convert(A var1);
    }

    private static abstract class GenomeAccess {
        private GenomeAccess() {
        }

        public IAllele getAllele(IGenome genome, int chromosome) {
            IChromosome[] genotype = genome.getChromosomes();
            IChromosome ch = genotype[chromosome];
            if (ch == null) {
                return null;
            }
            return this.getAllele(ch);
        }

        protected abstract IAllele getAllele(IChromosome var1);
    }
}

