/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.cofh.tileentity;

import cofh.api.tileentity.IRedstoneControl;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.world.World;

public final class DriverRedstoneControl
extends DriverTileEntity {
    @Override
    public Class<?> getTileEntityClass() {
        return IRedstoneControl.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
        return new Environment((IRedstoneControl)world.func_147438_o(x, y, z));
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<IRedstoneControl> {
        public Environment(IRedstoneControl tileEntity) {
            super(tileEntity, "redstone_control");
        }

        @Callback(doc="function():boolean --  Returns whether the control is disabled.")
        public Object[] getControlDisable(Context context, Arguments args) {
            return new Object[]{((IRedstoneControl)this.tileEntity).getControl() == IRedstoneControl.ControlMode.DISABLED};
        }

        @Callback(doc="function():int --  Returns the control status.")
        public Object[] getControlSetting(Context context, Arguments args) {
            return new Object[]{((IRedstoneControl)this.tileEntity).getControl().ordinal()};
        }

        @Callback(doc="function():string --  Returns the control status.")
        public Object[] getControlSettingName(Context context, Arguments args) {
            return new Object[]{((IRedstoneControl)this.tileEntity).getControl().name()};
        }

        @Callback(doc="function(int):string --  Returns the name of the given control")
        public Object[] getControlName(Context context, Arguments args) {
            IRedstoneControl.ControlMode m = IRedstoneControl.ControlMode.values()[args.checkInteger(0)];
            return new Object[]{m.name()};
        }

        @Callback(doc="function():boolean --  Returns whether the component is powered.")
        public Object[] isPowered(Context context, Arguments args) {
            return new Object[]{((IRedstoneControl)this.tileEntity).isPowered()};
        }

        @Callback(doc="function():boolean --  Sets whether the control tp disabled.")
        public Object[] setControlDisable(Context context, Arguments args) {
            ((IRedstoneControl)this.tileEntity).setControl(IRedstoneControl.ControlMode.DISABLED);
            return new Object[]{true};
        }

        @Callback(doc="function(state:int):boolean --  Sets the control status to the given value.")
        public Object[] setControlSetting(Context context, Arguments args) {
            if (args.isInteger(0)) {
                ((IRedstoneControl)this.tileEntity).setControl(IRedstoneControl.ControlMode.values()[args.checkInteger(0)]);
                return new Object[]{true};
            }
            ((IRedstoneControl)this.tileEntity).setControl(IRedstoneControl.ControlMode.valueOf((String)args.checkString(0)));
            return new Object[]{true};
        }
    }
}

