/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.containers.ContainerCustomizeBlock;
import net.geforcemods.securitycraft.gui.components.GuiItemButton;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.geforcemods.securitycraft.network.packets.PacketSToggleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeBlock
extends GuiContainer {
    private CustomizableSCTE tileEntity;
    private GuiItemButton[] descriptionButtons = new GuiItemButton[5];
    private GuiButton[] optionButtons = new GuiButton[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final String blockName;

    public GuiCustomizeBlock(InventoryPlayer par1InventoryPlayer, CustomizableSCTE par2TileEntity) {
        super((Container)new ContainerCustomizeBlock(par1InventoryPlayer, par2TileEntity));
        this.tileEntity = par2TileEntity;
        this.blockName = Minecraft.func_71410_x().field_71441_e.func_147439_a(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e).func_149739_a().substring(5);
    }

    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        for (i = 0; i < this.tileEntity.getNumberOfCustomizableOptions(); ++i) {
            this.descriptionButtons[i] = new GuiItemButton(i, this.field_147003_i + 130, this.field_147009_r + 10 + i * 25, 20, 20, "", field_146296_j, new ItemStack((Item)this.tileEntity.acceptedModules()[i].getItem()));
            this.field_146292_n.add(this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((GuiButton)this.descriptionButtons[i], 20);
        }
        if (this.tileEntity.customOptions() != null) {
            for (i = 0; i < this.tileEntity.customOptions().length; ++i) {
                this.optionButtons[i] = new GuiButton(i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, this.getOptionButtonTitle(this.tileEntity.customOptions()[i]));
                this.optionButtons[i].packedFGColour = this.tileEntity.customOptions()[i].toString().matches(this.tileEntity.customOptions()[i].getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
                this.field_146292_n.add(this.optionButtons[i]);
                this.hoverCheckers[i + this.tileEntity.getNumberOfCustomizableOptions()] = new HoverChecker(this.optionButtons[i], 20);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY) || i >= this.tileEntity.getNumberOfCustomizableOptions()) continue;
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getModuleDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
    }

    protected void func_146979_b(int par1, int par2) {
        String s = this.tileEntity.func_145818_k_() ? this.tileEntity.func_145825_b() : I18n.func_135052_a((String)this.tileEntity.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("securitycraft:textures/gui/container/customize" + this.tileEntity.getNumberOfCustomizableOptions() + ".png"));
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!(guibutton instanceof GuiItemButton)) {
            Option<?> tempOption = this.tileEntity.customOptions()[guibutton.field_146127_k];
            tempOption.toggle();
            guibutton.packedFGColour = tempOption.toString().matches(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
            guibutton.field_146126_j = this.getOptionButtonTitle(tempOption);
            mod_SecurityCraft.network.sendToServer((IMessage)new PacketSToggleOption(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, guibutton.field_146127_k));
        }
    }

    private String getModuleDescription(int buttonID) {
        String moduleDescription = "module." + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().func_77658_a().substring(5) + ".description";
        return StatCollector.func_74838_a((String)(this.descriptionButtons[buttonID].getItemStack().func_77658_a() + ".name")) + ":" + EnumChatFormatting.RESET + "\n\n" + StatCollector.func_74838_a((String)moduleDescription);
    }

    private String getOptionDescription(int buttonID) {
        String optionDescription = "option." + this.blockName + "." + this.tileEntity.customOptions()[buttonID - this.tileEntity.getNumberOfCustomizableOptions()].getName();
        return StatCollector.func_74838_a((String)optionDescription);
    }

    private String getOptionButtonTitle(Option<?> option) {
        return (StatCollector.func_74838_a((String)("option." + this.blockName + "." + option.getName())) + " ").replace("#", option.toString());
    }
}

