/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.client.texture.CableBusTextures;
import appeng.parts.automation.PartAnnihilationPlane;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class PartIdentityAnnihilationPlane
extends PartAnnihilationPlane {
    private static final IIcon ACTIVE_ICON = CableBusTextures.BlockIdentityAnnihilationPlaneOn.getIcon();
    private static final float SILK_TOUCH_FACTOR = 16.0f;

    public PartIdentityAnnihilationPlane(ItemStack is) {
        super(is);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderStaticWithIcon(x, y, z, rh, renderer, ACTIVE_ICON);
    }

    @Override
    protected boolean isAnnihilationPlane(TileEntity blockTileEntity, ForgeDirection side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == this.getClass();
        }
        return false;
    }

    @Override
    protected float calculateEnergyUsage(WorldServer w, int x, int y, int z, List<ItemStack> items) {
        float requiredEnergy = super.calculateEnergyUsage(w, x, y, z, items);
        return requiredEnergy * 16.0f;
    }

    @Override
    protected List<ItemStack> obtainBlockDrops(WorldServer w, int x, int y, int z) {
        int blockMeta;
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)w);
        Block block = w.func_147439_a(x, y, z);
        if (block.canSilkHarvest((World)w, (EntityPlayer)fakePlayer, x, y, z, blockMeta = w.func_72805_g(x, y, z))) {
            ArrayList<ItemStack> out = new ArrayList<ItemStack>(1);
            Item item = Item.func_150898_a((Block)block);
            if (item != null) {
                int meta = 0;
                if (item.func_77614_k()) {
                    meta = blockMeta;
                }
                ItemStack itemstack = new ItemStack(item, 1, meta);
                out.add(itemstack);
            }
            return out;
        }
        return super.obtainBlockDrops(w, x, y, z);
    }
}

