/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.INetworkToolAgent;
import appeng.client.ClientHelper;
import appeng.container.AEBaseContainer;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.integration.IntegrationType;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolViewer;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import buildcraft.api.tools.IToolWrench;
import com.google.common.base.Optional;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.Interface(iface="buildcraft.api.tools.IToolWrench", iname=IntegrationType.BuildCraftCore)
public class ToolNetworkTool
extends AEBaseItem
implements IGuiItem,
IAEWrench,
IToolWrench {
    public ToolNetworkTool() {
        super((Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.NetworkTool));
        this.func_77625_d(1);
        this.setHarvestLevel("wrench", 0);
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return new NetworkToolViewer(is, (IGridHost)(te instanceof IGridHost ? te : null));
    }

    public ItemStack func_77659_a(ItemStack it, World w, EntityPlayer p) {
        if (Platform.isClient()) {
            MovingObjectPosition mop = ClientHelper.proxy.getMOP();
            if (mop == null) {
                this.onItemUseFirst(it, p, w, 0, 0, 0, -1, 0.0f, 0.0f, 0.0f);
            } else {
                int i = mop.field_72311_b;
                int j = mop.field_72312_c;
                int k = mop.field_72309_d;
                if (w.func_147439_a(i, j, k).isAir((IBlockAccess)w, i, j, k)) {
                    this.onItemUseFirst(it, p, w, 0, 0, 0, -1, 0.0f, 0.0f, 0.0f);
                }
            }
        }
        return it;
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        MovingObjectPosition mop = new MovingObjectPosition(x, y, z, side, Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPartHost) {
            SelectedPart part = ((IPartHost)te).selectPart(mop.field_72307_f);
            if (part.part != null && part.part instanceof INetworkToolAgent && !((INetworkToolAgent)((Object)part.part)).showNetworkInfo(mop)) {
                return false;
            }
        } else if (te instanceof INetworkToolAgent && !((INetworkToolAgent)te).showNetworkInfo(mop)) {
            return false;
        }
        if (Platform.isClient()) {
            NetworkHandler.instance.sendToServer(new PacketClick(x, y, z, side, hitX, hitY, hitZ));
        }
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public boolean serverSideToolLogic(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side >= 0) {
            TileEntity te;
            if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
                return false;
            }
            Block b = w.func_147439_a(x, y, z);
            if (b != null && !p.func_70093_af() && !((te = w.func_147438_o(x, y, z)) instanceof IGridHost) && b.rotateBlock(w, x, y, z, ForgeDirection.getOrientation((int)side))) {
                b.func_149695_a(w, x, y, z, Platform.AIR_BLOCK);
                p.func_71038_i();
                return !w.field_72995_K;
            }
            if (!p.func_70093_af()) {
                if (p.field_71070_bA instanceof AEBaseContainer) {
                    return true;
                }
                te = w.func_147438_o(x, y, z);
                if (te instanceof IGridHost) {
                    Platform.openGUI(p, te, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_NETWORK_STATUS);
                } else {
                    Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_NETWORK_TOOL);
                }
                return true;
            }
            b.func_149727_a(w, x, y, z, p, side, hitX, hitY, hitZ);
        } else {
            Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_NETWORK_TOOL);
        }
        return false;
    }

    @Override
    public boolean canWrench(ItemStack is, EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71038_i();
    }
}

