/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.core.AEConfig;
import appeng.recipes.game.ShapelessRecipe;
import appeng.util.Platform;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class NEIAEShapelessRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == NEIAEShapelessRecipeHandler.class) {
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe recipe : recipes) {
                if (!(recipe instanceof ShapelessRecipe) || !((ShapelessRecipe)recipe).isEnabled()) continue;
                CachedShapelessRecipe cachedRecipe = new CachedShapelessRecipe((ShapelessRecipe)recipe);
                cachedRecipe.computeVisuals();
                this.arecipes.add(cachedRecipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            if (!(recipe instanceof ShapelessRecipe) || !((ShapelessRecipe)recipe).isEnabled() || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.func_77571_b(), (ItemStack)result)) continue;
            CachedShapelessRecipe cachedRecipe = new CachedShapelessRecipe((ShapelessRecipe)recipe);
            cachedRecipe.computeVisuals();
            this.arecipes.add(cachedRecipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            if (!(recipe instanceof ShapelessRecipe)) continue;
            CachedShapelessRecipe cachedRecipe = new CachedShapelessRecipe((ShapelessRecipe)recipe);
            if (!((ShapelessRecipe)recipe).isEnabled() || !cachedRecipe.contains(cachedRecipe.ingredients, ingredient.func_77973_b())) continue;
            cachedRecipe.computeVisuals();
            if (!cachedRecipe.contains(cachedRecipe.ingredients, ingredient)) continue;
            cachedRecipe.setIngredientPermutation(cachedRecipe.ingredients, ingredient);
            this.arecipes.add(cachedRecipe);
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"crafting2x2");
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner((GuiContainer)gui, (String)"crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"crafting2x2");
    }

    private boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public String getRecipeName() {
        return NEIClientUtils.translate((String)"recipe.shapeless", (Object[])new Object[0]);
    }

    private class CachedShapelessRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> ingredients;
        private final PositionedStack result;

        public CachedShapelessRecipe(ShapelessRecipe recipe) {
            super((TemplateRecipeHandler)NEIAEShapelessRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.func_77571_b(), 119, 24);
            this.ingredients = new ArrayList<PositionedStack>();
            this.setIngredients(recipe.getInput().toArray());
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIAEShapelessRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        private void setIngredients(Object[] items) {
            boolean useSingleItems = AEConfig.instance.disableColoredCableRecipesInNEI();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (items.length <= y * 3 + x) continue;
                    IIngredient ing = (IIngredient)items[y * 3 + x];
                    try {
                        ItemStack[] is = ing.getItemStackSet();
                        PositionedStack stack = new PositionedStack((Object)(useSingleItems ? Platform.findPreferred(is) : ing.getItemStackSet()), 25 + x * 18, 6 + y * 18, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                        continue;
                    }
                    catch (RegistrationError registrationError) {
                        continue;
                    }
                    catch (MissingIngredientError missingIngredientError) {
                        // empty catch block
                    }
                }
            }
        }

        private void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }
    }
}

