/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils.helpers;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sonar.core.SonarCore;
import sonar.core.utils.IRegistryObject;

public abstract class RegistryHelper<T extends IRegistryObject> {
    private List<T> objects = new ArrayList<T>();
    private Map<String, Byte> objectIDs = new THashMap();
    private Map<Byte, String> objectNames = new THashMap();

    public abstract void register();

    public abstract String registeryType();

    public void removeAll() {
        this.objects.clear();
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public T getRegisteredObject(byte objectID) {
        String helperName = this.objectNames.get(objectID);
        if (helperName == null || helperName.isEmpty()) {
            return null;
        }
        for (IRegistryObject provider : this.objects) {
            if (!provider.getName().equals(helperName)) continue;
            return (T)provider;
        }
        return null;
    }

    public T getRegisteredObject(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (IRegistryObject provider : this.objects) {
            if (!provider.getName().equals(name)) continue;
            return (T)provider;
        }
        return null;
    }

    public void registerObject(T object) {
        if (!object.isLoadable()) {
            SonarCore.logger.warn(this.registeryType() + " wasn't loadable: " + object.getName());
            return;
        }
        if (object != null) {
            if (this.getRegisteredObject(object.getName()) == null) {
                this.objects.add(object);
                byte id = (byte)this.objectIDs.size();
                this.objectIDs.put(object.getName(), id);
                this.objectNames.put(id, object.getName());
                SonarCore.logger.info("Loaded " + this.registeryType() + ": " + object.getName());
            } else {
                SonarCore.logger.warn(this.registeryType() + " DUPLICATE ID - skipping " + object.getName());
            }
        }
    }

    public byte getObjectID(String name) {
        byte id = this.objectIDs.get(name);
        return id;
    }
}

