/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils.helpers;

import cofh.api.energy.EnergyStorage;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class NBTHelper {
    public static void writeEnergyStorage(EnergyStorage storage, NBTTagCompound nbt) {
        NBTTagCompound energyTag = new NBTTagCompound();
        storage.writeToNBT(energyTag);
        nbt.func_74782_a("energyStorage", (NBTBase)energyTag);
    }

    public static void readEnergyStorage(EnergyStorage storage, NBTTagCompound nbt) {
        if (nbt.func_74764_b("energyStorage")) {
            storage.readFromNBT(nbt.func_74775_l("energyStorage"));
        }
    }

    public static void writeFluidToBuf(FluidStack stack, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((Fluid)stack.getFluid()));
        buf.writeInt(stack.amount);
        if (stack.tag != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static FluidStack readFluidFromBuf(ByteBuf buf) {
        String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (fluidName == null || FluidRegistry.getFluid((String)fluidName) == null) {
            return null;
        }
        FluidStack stack = new FluidStack(FluidRegistry.getFluid((String)fluidName), buf.readInt());
        if (buf.readBoolean()) {
            stack.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
        return stack;
    }

    public static void writeTankInfo(FluidTankInfo tank, NBTTagCompound nbt) {
        tank.fluid.writeToNBT(nbt);
        nbt.func_74768_a("capacity", tank.capacity);
    }

    public static FluidTankInfo readTankInfo(NBTTagCompound nbt) {
        return new FluidTankInfo(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt), nbt.func_74762_e("capacity"));
    }

    public static enum SyncType {
        SAVE,
        SYNC,
        DROP,
        SPECIAL;


        public static byte getID(SyncType type) {
            switch (type) {
                case SYNC: {
                    return 1;
                }
                case DROP: {
                    return 2;
                }
                case SPECIAL: {
                    return 3;
                }
            }
            return 0;
        }

        public static SyncType getType(int i) {
            switch (i) {
                case 1: {
                    return SYNC;
                }
                case 2: {
                    return DROP;
                }
                case 3: {
                    return SPECIAL;
                }
            }
            return SAVE;
        }
    }
}

