/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils.helpers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class InventoryHelper {
    public static boolean isPlayerInventoryFull(EntityPlayer player) {
        return player.field_71071_by.func_70447_i() == -1;
    }

    public static void extractItems(TileEntity pull, TileEntity push, int pullSide, int pushSide, IInventoryFilter filter) {
        if (pull == null || push == null) {
            return;
        }
        if (pull instanceof IInventory && push instanceof IInventory) {
            Block block;
            IInventory start = (IInventory)pull;
            IInventory stop = (IInventory)push;
            int[] pullAccess = null;
            int[] pushAccess = null;
            if (pull instanceof TileEntityChest && (block = pull.field_145854_h) instanceof BlockChest) {
                start = ((BlockChest)block).func_149951_m(pull.func_145831_w(), pull.field_145851_c, pull.field_145848_d, pull.field_145849_e);
            }
            if (push instanceof TileEntityChest && (block = push.field_145854_h) instanceof BlockChest) {
                stop = ((BlockChest)block).func_149951_m(push.func_145831_w(), push.field_145851_c, push.field_145848_d, push.field_145849_e);
            }
            if (pull instanceof ISidedInventory) {
                pullAccess = ((ISidedInventory)pull).func_94128_d(pullSide);
            }
            if (push instanceof ISidedInventory) {
                pushAccess = ((ISidedInventory)push).func_94128_d(pushSide);
            }
            InventoryHelper.extractItems(new InventoryOperation(start, pullSide, pullAccess, filter), new InventoryOperation(stop, pushSide, pushAccess, filter));
        }
    }

    public static ItemStack addItems(TileEntity push, ItemStack stack, int pushSide, IInventoryFilter filter) {
        if (stack == null || push == null) {
            return stack;
        }
        if ((filter == null || filter.matches(stack)) && push instanceof IInventory) {
            Block block;
            IInventory start = (IInventory)push;
            int[] pushAccess = null;
            if (push instanceof TileEntityChest && (block = push.field_145854_h) instanceof BlockChest) {
                start = ((BlockChest)block).func_149951_m(push.func_145831_w(), push.field_145851_c, push.field_145848_d, push.field_145849_e);
            }
            if (push instanceof ISidedInventory) {
                pushAccess = ((ISidedInventory)push).func_94128_d(pushSide);
            }
            return InventoryHelper.exportItems(new InventoryOperation(start, pushSide, pushAccess, null), stack);
        }
        return stack;
    }

    private static ItemStack exportItems(InventoryOperation push, ItemStack stack) {
        ItemStack exported = stack.func_77946_l();
        while (exported != null && InventoryHelper.canInsert(push, exported) != -999) {
            int max;
            int insert = InventoryHelper.canInsert(push, exported);
            ItemStack pushStack = push.getInv().func_70301_a(insert);
            if (exported == null) continue;
            if (pushStack == null) {
                max = Math.min(exported.func_77976_d(), push.getInv().func_70297_j_());
                if (max < exported.field_77994_a) continue;
                push.getInv().func_70299_a(insert, exported);
                exported = null;
                continue;
            }
            if (stack.func_77973_b() != pushStack.func_77973_b() || (max = Math.min(pushStack.func_77976_d(), push.getInv().func_70297_j_())) <= pushStack.field_77994_a) continue;
            int l = Math.min(exported.field_77994_a, max - pushStack.field_77994_a);
            exported.field_77994_a -= l;
            if (exported.field_77994_a <= 0) {
                exported = null;
            }
            ItemStack moveStack = pushStack.func_77946_l();
            moveStack.field_77994_a += l;
            push.getInv().func_70299_a(insert, moveStack);
        }
        return exported;
    }

    private static void extractItems(InventoryOperation pull, InventoryOperation push) {
        if (pull.access == null) {
            for (int j = 0; j < pull.getInv().func_70302_i_(); ++j) {
                int extract = InventoryHelper.canExtract(pull, push, j);
                if (extract == -999) continue;
                InventoryHelper.performExtract(pull, push, j, extract);
            }
        } else {
            for (int j = 0; j < pull.access.length; ++j) {
                int extract = InventoryHelper.canExtract(pull, push, pull.access[j]);
                if (extract == -999) continue;
                InventoryHelper.performExtract(pull, push, pull.access[j], extract);
            }
        }
    }

    private static int canExtract(InventoryOperation pull, InventoryOperation push, int slot) {
        int insert;
        ItemStack target = pull.getInv().func_70301_a(slot);
        if ((!pull.hasAccess() || pull.hasAccess() && pull.getSidedInv().func_102008_b(slot, target, pull.side)) && target != null && (insert = InventoryHelper.canInsert(push, target)) != -999 && (!pull.hasFilter() || pull.filter.matches(target))) {
            return insert;
        }
        return -999;
    }

    private static int canInsert(InventoryOperation push, ItemStack stack) {
        int emptySlot = -999;
        if (push.access == null) {
            for (int j = 0; j < push.getInv().func_70302_i_(); ++j) {
                ItemStack target = push.getInv().func_70301_a(j);
                if (target != null && target.field_77994_a < target.func_77976_d() && target.field_77994_a < push.getInv().func_70297_j_() && target.func_77973_b() == stack.func_77973_b() && target.func_77960_j() == stack.func_77960_j()) {
                    if (ItemStack.func_77970_a((ItemStack)target, (ItemStack)stack)) {
                        return j;
                    }
                }
                if (emptySlot != -999 || target != null) continue;
                emptySlot = j;
            }
            return emptySlot;
        }
        ISidedInventory inv = push.getSidedInv();
        for (int j = 0; j < push.access.length; ++j) {
            if (!inv.func_102007_a(push.access[j], stack, push.side)) continue;
            ItemStack target = push.getInv().func_70301_a(push.access[j]);
            if (target != null && target.field_77994_a != target.func_77976_d() && target.field_77994_a != push.getInv().func_70297_j_() && target.func_77973_b() == stack.func_77973_b() && target.func_77960_j() == stack.func_77960_j()) {
                if (ItemStack.func_77970_a((ItemStack)target, (ItemStack)stack)) {
                    return push.access[j];
                }
            }
            if (emptySlot != -999 || target != null) continue;
            emptySlot = push.access[j];
        }
        return emptySlot;
    }

    private static void performExtract(InventoryOperation pull, InventoryOperation push, int pullID, int pushID) {
        ItemStack pullStack = pull.getInv().func_70301_a(pullID);
        ItemStack pushStack = push.getSidedInv().func_70301_a(pushID);
        if (pullStack != null && (!push.hasFilter() || push.filter.matches(pullStack))) {
            int max;
            if (pushStack == null) {
                int max2 = Math.min(pullStack.func_77976_d(), push.getInv().func_70297_j_());
                if (max2 >= pullStack.field_77994_a) {
                    push.getInv().func_70299_a(pushID, pullStack);
                    pull.getInv().func_70299_a(pullID, null);
                }
            } else if (pullStack.func_77973_b() == pushStack.func_77973_b() && (max = Math.min(pushStack.func_77976_d(), push.getInv().func_70297_j_())) > pushStack.field_77994_a) {
                int l = Math.min(pullStack.field_77994_a, max - pushStack.field_77994_a);
                pull.getInv().func_70298_a(pullID, l);
                ItemStack moveStack = pushStack.func_77946_l();
                if (pullStack.field_77994_a - l <= 0) {
                    pull.getInv().func_70299_a(pullID, null);
                }
                moveStack.field_77994_a += l;
                push.getInv().func_70299_a(pushID, moveStack);
            }
        }
    }

    public static interface IInventoryFilter {
        public boolean matches(ItemStack var1);
    }

    private static class InventoryOperation {
        public Object inv;
        public int side;
        private int[] access;
        public IInventoryFilter filter;

        public InventoryOperation(Object inv, int side, int[] access, IInventoryFilter filter) {
            this.inv = inv;
            this.side = side;
            this.access = access;
            this.filter = filter;
        }

        public boolean hasFilter() {
            return this.filter != null;
        }

        public boolean hasAccess() {
            return this.access != null;
        }

        public IInventory getInv() {
            return (IInventory)this.inv;
        }

        public ISidedInventory getSidedInv() {
            return (ISidedInventory)this.inv;
        }
    }
}

