/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils.helpers;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.math.BigDecimal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class FontHelper {
    public static void text(String info, int x, int y, int colour) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        switch (colour) {
            case 0: {
                render.func_78276_b(info, x, y, 0x404040);
                break;
            }
            case 1: {
                render.func_78276_b(info, x, y, 1);
                break;
            }
            case 2: {
                render.func_78276_b(info, x, y, -1);
                break;
            }
            default: {
                render.func_78276_b(info, x, y, colour);
            }
        }
    }

    public static void textCentre(String info, int xSize, int y, int colour) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        switch (colour) {
            case 0: {
                render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, 0x404040);
                break;
            }
            case 1: {
                render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, 1);
                break;
            }
            case 2: {
                render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, -1);
                break;
            }
            default: {
                render.func_78276_b(info, xSize / 2 - FontHelper.width(info) / 2, y, colour);
            }
        }
    }

    public static int width(String info) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        return render.func_78256_a(info);
    }

    public static void textOffsetCentre(String info, int xCentre, int y, int colour) {
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        switch (colour) {
            case 0: {
                render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, 0x404040);
                break;
            }
            case 1: {
                render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, 1);
                break;
            }
            case 2: {
                render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, -1);
                break;
            }
            default: {
                render.func_78276_b(info, xCentre - FontHelper.width(info) / 2, y, colour);
            }
        }
    }

    public static void sendMessage(String string, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            player.func_146105_b((IChatComponent)new ChatComponentText(string));
        }
    }

    public static String formatStorage(long power) {
        if (power < 1000L) {
            return power + " RF";
        }
        if (power < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000.0f)) + " KRF";
        }
        if (power < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000000.0f)) + " MRF";
        }
        return FontHelper.roundValue(2, Float.valueOf((float)power / 1.0E9f)) + " BRF";
    }

    public static String formatOutput(long power) {
        if (power < 1000L) {
            return power + " RF/T";
        }
        if (power < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000.0f)) + " KRF/T";
        }
        if (power < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)power / 1000000.0f)) + " MRF/T";
        }
        return FontHelper.roundValue(2, Float.valueOf((float)power / 1.0E9f)) + " BRF/T";
    }

    public static String formatStackSize(long stackSize) {
        if (stackSize < 10000L) {
            return " " + stackSize;
        }
        if (stackSize < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)stackSize / 1000.0f)) + " K";
        }
        if (stackSize < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)stackSize / 1000000.0f)) + " M";
        }
        return FontHelper.roundValue(2, Float.valueOf((float)stackSize / 1.0E9f)) + " B";
    }

    public static String formatFluidSize(long fluidSize) {
        if (fluidSize < 10000L) {
            return " " + fluidSize;
        }
        if (fluidSize < 1000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)fluidSize / 1000.0f)) + " K";
        }
        if (fluidSize < 1000000000L) {
            return FontHelper.roundValue(1, Float.valueOf((float)fluidSize / 1000000.0f)) + " M";
        }
        return FontHelper.roundValue(2, Float.valueOf((float)fluidSize / 1.0E9f)) + " B";
    }

    public static Float roundValue(int decimalPlace, Float d) {
        BigDecimal bd = new BigDecimal(Float.toString(d.floatValue()));
        bd = bd.setScale(decimalPlace, 4);
        return Float.valueOf(bd.floatValue());
    }

    public static boolean addDigitsToString(GuiTextField box, char c, int i) {
        switch (c) {
            case '\u0001': {
                return box.func_146201_a(c, i);
            }
            case '\u0003': {
                return box.func_146201_a(c, i);
            }
            case '\u0016': {
                return false;
            }
            case '\u0018': {
                return box.func_146201_a(c, i);
            }
        }
        switch (i) {
            case 14: {
                return box.func_146201_a(c, i);
            }
            case 199: {
                return box.func_146201_a(c, i);
            }
            case 203: {
                return box.func_146201_a(c, i);
            }
            case 205: {
                return box.func_146201_a(c, i);
            }
            case 207: {
                return box.func_146201_a(c, i);
            }
            case 211: {
                return box.func_146201_a(c, i);
            }
        }
        if (Character.isDigit(c)) {
            return box.func_146201_a(c, i);
        }
        return false;
    }

    public static String translate(String string) {
        String local = StatCollector.func_74838_a((String)string);
        if (!local.equals(string)) {
            return local;
        }
        return StatCollector.func_150826_b((String)string);
    }

    public static String fullTranslate(String s) {
        String ret = LanguageRegistry.instance().getStringLocalization(s);
        if (ret.length() == 0) {
            ret = LanguageRegistry.instance().getStringLocalization(s, "en_US");
        }
        if (ret.length() == 0) {
            ret = FontHelper.translate(s);
        }
        if (ret.length() == 0) {
            return s;
        }
        return ret;
    }
}

