/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.helpers.NBTHelper;

public class SyncString
implements ISyncPart {
    private String c = "";
    private String last = "";
    private byte id;

    public SyncString(int id) {
        this.id = (byte)id;
    }

    public SyncString(int id, String def) {
        this.id = (byte)id;
        this.c = def;
        this.last = def;
    }

    @Override
    public boolean equal() {
        return this.c.equals(this.last);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (!this.equal()) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.c);
            this.last = this.c;
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.c = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.c.isEmpty() || this.c == null) {
            this.c = "";
        }
        if (type == NBTHelper.SyncType.SYNC) {
            if (!this.equal()) {
                nbt.func_74778_a(String.valueOf(this.id), this.c);
                this.last = this.c;
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74778_a(String.valueOf(this.id), this.c);
            this.last = this.c;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (nbt.func_74764_b(String.valueOf(this.id))) {
                this.c = nbt.func_74779_i(String.valueOf(this.id));
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            this.c = nbt.func_74779_i(String.valueOf(this.id));
        }
    }

    public void setString(String string) {
        this.c = string;
    }

    public String getString() {
        return this.c;
    }
}

