/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.helpers.NBTHelper;

public class SyncLong
implements ISyncPart {
    private long c = 0L;
    private long last = 0L;
    private byte id;

    public SyncLong(int id) {
        this.id = (byte)id;
    }

    public SyncLong(int id, long def) {
        this.id = (byte)id;
        this.c = def;
        this.last = def;
    }

    @Override
    public boolean equal() {
        return this.c == this.last;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (!this.equal()) {
            buf.writeBoolean(true);
            buf.writeLong(this.c);
            this.last = this.c;
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.c = buf.readLong();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (!this.equal()) {
                nbt.func_74772_a(String.valueOf(this.id), this.c);
                this.last = this.c;
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74772_a(String.valueOf(this.id), this.c);
            this.last = this.c;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (nbt.func_74764_b(String.valueOf(this.id))) {
                this.c = nbt.func_74763_f(String.valueOf(this.id));
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            this.c = nbt.func_74763_f(String.valueOf(this.id));
        }
    }

    public void setLong(long value) {
        this.c = value;
    }

    public long getLong() {
        return this.c;
    }

    public void increaseBy(int increase) {
        this.c += (long)increase;
    }
}

