/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.helpers.NBTHelper;

public class SyncByte
implements ISyncPart {
    private byte c = 0;
    private byte last = 0;
    private byte id;

    public SyncByte(int id) {
        this.id = (byte)id;
    }

    public SyncByte(int id, int def) {
        this.id = (byte)id;
        this.c = (byte)def;
        this.last = (byte)def;
    }

    @Override
    public boolean equal() {
        return this.c == this.last;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (!this.equal()) {
            buf.writeBoolean(true);
            buf.writeByte((int)this.c);
            this.last = this.c;
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.c = buf.readByte();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (!this.equal()) {
                nbt.func_74774_a(String.valueOf(this.id), this.c);
                this.last = this.c;
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74774_a(String.valueOf(this.id), this.c);
            this.last = this.c;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (nbt.func_74764_b(String.valueOf(this.id))) {
                this.c = nbt.func_74771_c(String.valueOf(this.id));
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            this.c = nbt.func_74771_c(String.valueOf(this.id));
        }
    }

    public void setByte(byte value) {
        this.c = value;
    }

    public byte getByte() {
        return this.c;
    }

    public void increaseBy(int increase) {
        this.c = (byte)(this.c + increase);
    }
}

