/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.helpers.NBTHelper;

public class SyncBoolean
implements ISyncPart {
    private boolean c = false;
    private boolean last = false;
    private byte id;

    public SyncBoolean(int id) {
        this.id = (byte)id;
    }

    public SyncBoolean(int id, boolean def) {
        this.id = (byte)id;
        this.c = def;
        this.last = def;
    }

    @Override
    public boolean equal() {
        return this.c == this.last;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeBoolean(this.c);
        this.last = this.c;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.c = buf.readBoolean();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (!this.equal()) {
                nbt.func_74757_a(String.valueOf(this.id), this.c);
                this.last = this.c;
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74757_a(String.valueOf(this.id), this.c);
            this.last = this.c;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (nbt.func_74764_b(String.valueOf(this.id))) {
                this.c = nbt.func_74767_n(String.valueOf(this.id));
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            this.c = nbt.func_74767_n(String.valueOf(this.id));
        }
    }

    public void setBoolean(boolean value) {
        this.c = value;
    }

    public boolean getBoolean() {
        return this.c;
    }
}

