/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.network.utils.ISyncTile;
import sonar.core.utils.helpers.NBTHelper;

public class PacketTileSync
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public NBTTagCompound tag;
    public NBTHelper.SyncType type;

    public PacketTileSync() {
    }

    public PacketTileSync(int xCoord, int yCoord, int zCoord, NBTTagCompound tag) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.tag = tag;
    }

    public PacketTileSync(int xCoord, int yCoord, int zCoord, NBTTagCompound tag, NBTHelper.SyncType type) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.tag = tag;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70170_p != null) {
            Object tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
            if ((tile = FMPHelper.checkObject(tile)) == null) {
                return;
            }
            NBTHelper.SyncType type = NBTHelper.SyncType.SYNC;
            if (buf.readBoolean()) {
                type = NBTHelper.SyncType.getType(buf.readByte());
            }
            if (tile instanceof ISyncTile) {
                ISyncTile sync = (ISyncTile)tile;
                sync.readData(this.tag, type);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        if (this.type == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeByte((int)NBTHelper.SyncType.getID(this.type));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketTileSync, IMessage> {
        public IMessage onMessage(PacketTileSync message, MessageContext ctx) {
            return null;
        }
    }
}

