/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.World;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.network.utils.ITextField;

public class PacketTextField
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int id;
    public String string;

    public PacketTextField() {
    }

    public PacketTextField(String string, int xCoord, int yCoord, int zCoord, int id) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.string = string;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.string);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<PacketTextField, IMessage> {
        public IMessage onMessage(PacketTextField message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            Object te = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            if ((te = FMPHelper.checkObject(te)) == null) {
                return null;
            }
            if (te instanceof ITextField) {
                ITextField field = (ITextField)te;
                field.textTyped(message.string, message.id);
            }
            return null;
        }
    }
}

