/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.network.PacketTileSync;
import sonar.core.network.utils.ISyncTile;
import sonar.core.utils.helpers.NBTHelper;

public class PacketRequestSync
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public PacketRequestSync() {
    }

    public PacketRequestSync(int xCoord, int yCoord, int zCoord) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
    }

    public static class Handler
    implements IMessageHandler<PacketRequestSync, IMessage> {
        public IMessage onMessage(PacketRequestSync message, MessageContext ctx) {
            TileEntity tile;
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p != null && (tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_147438_o(message.xCoord, message.yCoord, message.zCoord)) != null && tile instanceof ISyncTile) {
                NBTTagCompound tag = new NBTTagCompound();
                ISyncTile sync = (ISyncTile)tile;
                sync.writeData(tag, NBTHelper.SyncType.SYNC);
                if (!tag.func_82582_d()) {
                    return new PacketTileSync(message.xCoord, message.yCoord, message.zCoord, tag);
                }
            }
            return null;
        }
    }
}

