/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.utils.IMachineButtons;

public class PacketMachineButton
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int id;
    public int value;

    public PacketMachineButton() {
    }

    public PacketMachineButton(int id, int value, int xCoord, int yCoord, int zCoord) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.id = id;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.id = buf.readInt();
        this.value = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeInt(this.id);
        buf.writeInt(this.value);
    }

    public static class Handler
    implements IMessageHandler<PacketMachineButton, IMessage> {
        public IMessage onMessage(PacketMachineButton message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            if (te == null) {
                return null;
            }
            if (te instanceof IMachineButtons) {
                ((IMachineButtons)te).buttonPress(message.id, message.value);
            }
            return null;
        }
    }
}

