/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.IByteBufTile;

public class PacketByteBufServer
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int id;
    public IByteBufTile tile;
    public ByteBuf buf;

    public PacketByteBufServer() {
    }

    public PacketByteBufServer(IByteBufTile tile, int x, int y, int z, int id) {
        this.tile = tile;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.id = buf.readInt();
        this.buf = buf;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeInt(this.id);
        this.tile.writePacket(buf, this.id);
    }

    public static class HandlerServer
    implements IMessageHandler<PacketByteBufServer, IMessage> {
        public IMessage onMessage(PacketByteBufServer message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            if (world != null) {
                TileEntity tile = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
                if (tile == null) {
                    return null;
                }
                if (tile instanceof IByteBufTile) {
                    IByteBufTile packet = (IByteBufTile)tile;
                    packet.readPacket(message.buf, message.id);
                } else {
                    TileHandler handler = FMPHelper.getHandler(tile);
                    if (handler != null && handler instanceof IByteBufTile) {
                        ((IByteBufTile)((Object)handler)).readPacket(message.buf, message.id);
                    }
                }
            }
            return null;
        }
    }
}

