/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.IByteBufTile;

public class PacketByteBufClient
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int id;
    public IByteBufTile tile;
    public ByteBuf buf;

    public PacketByteBufClient() {
    }

    public PacketByteBufClient(IByteBufTile tile, int x, int y, int z, int id) {
        this.tile = tile;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        TileEntity tile;
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.id = buf.readInt();
        this.buf = buf;
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70170_p != null && (tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_147438_o(this.xCoord, this.yCoord, this.zCoord)) != null) {
            if (tile instanceof IByteBufTile) {
                IByteBufTile packet = (IByteBufTile)tile;
                packet.readPacket(buf, this.id);
            } else {
                TileHandler handler = FMPHelper.getHandler(tile);
                if (handler != null && handler instanceof IByteBufTile) {
                    ((IByteBufTile)((Object)handler)).readPacket(buf, this.id);
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeInt(this.id);
        this.tile.writePacket(buf, this.id);
    }

    public static class HandlerClient
    implements IMessageHandler<PacketByteBufClient, IMessage> {
        public IMessage onMessage(PacketByteBufClient message, MessageContext ctx) {
            return null;
        }
    }
}

