/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.fluid;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.utils.helpers.NBTHelper;

public class StoredFluidStack {
    public FluidStack fluid;
    public long stored;
    public long capacity;

    public StoredFluidStack(FluidStack stack, long capacity) {
        this.fluid = stack.copy();
        this.stored = stack.amount;
        this.capacity = capacity;
    }

    public StoredFluidStack(FluidStack stack, long stored, long capacity) {
        this.fluid = stack.copy();
        this.stored = stored;
        this.capacity = capacity;
    }

    public void add(StoredFluidStack stack) {
        if (this.equalStack(stack.fluid)) {
            this.stored += stack.stored;
            this.capacity += stack.capacity;
        }
    }

    public void remove(StoredFluidStack stack) {
        if (this.equalStack(stack.fluid)) {
            this.stored -= stack.stored;
            this.capacity -= stack.capacity;
        }
    }

    public boolean equalStack(FluidStack stack) {
        if (this.fluid == null || stack == null || stack.amount == 0) {
            return false;
        }
        return this.fluid.isFluidEqual(stack);
    }

    public static StoredFluidStack readFromNBT(NBTTagCompound tag) {
        return new StoredFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag), tag.func_74763_f("stored"), tag.func_74763_f("capacity"));
    }

    public static void writeToNBT(NBTTagCompound tag, StoredFluidStack storedStack) {
        storedStack.fluid.writeToNBT(tag);
        tag.func_74772_a("stored", storedStack.stored);
        tag.func_74772_a("capacity", storedStack.capacity);
    }

    public static StoredFluidStack readFromBuf(ByteBuf buf) {
        return new StoredFluidStack(NBTHelper.readFluidFromBuf(buf), buf.readLong(), buf.readLong());
    }

    public static void writeToBuf(ByteBuf buf, StoredFluidStack storedStack) {
        NBTHelper.writeFluidToBuf(storedStack.fluid, buf);
        buf.writeLong(storedStack.stored);
        buf.writeLong(storedStack.capacity);
    }
}

