/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.energy;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.item.ItemStack;
import sonar.core.energy.DischargeValues;
import sonar.core.energy.EnergyCharge;
import sonar.core.integration.SonarAPI;

public class ChargingUtils {
    public static boolean canDischarge(ItemStack energy, EnergyStorage energyStorage) {
        if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
            return false;
        }
        if (energy == null) {
            return false;
        }
        if (energy.func_77973_b() instanceof IEnergyContainerItem) {
            return true;
        }
        if (SonarAPI.ic2Loaded() && energy.func_77973_b() instanceof IElectricItem) {
            return true;
        }
        return DischargeValues.getValueOf(energy) > 0;
    }

    public static boolean canCharge(ItemStack energy, EnergyStorage energyStorage) {
        if (energyStorage.getEnergyStored() == 0) {
            return false;
        }
        if (energy == null) {
            return false;
        }
        if (energy.func_77973_b() instanceof IEnergyContainerItem) {
            return true;
        }
        return SonarAPI.ic2Loaded() && energy.func_77973_b() instanceof IElectricItem;
    }

    public static EnergyCharge discharge(ItemStack energy, EnergyStorage energyStorage) {
        int max = energyStorage.getMaxEnergyStored();
        int stored = energyStorage.getEnergyStored();
        if (energy != null && stored < max) {
            if (energy.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)energy.func_77973_b();
                int itemEnergy = item.getEnergyStored(energy);
                int toTransfer = Math.round(Math.min(itemEnergy, max - stored));
                return new EnergyCharge(item.extractEnergy(energy, toTransfer, false), energy, false);
            }
            if (SonarAPI.ic2Loaded() && energy.func_77973_b() instanceof ISpecialElectricItem) {
                ISpecialElectricItem special = (ISpecialElectricItem)energy.func_77973_b();
                IElectricItemManager manager = special.getManager(energy);
                int itemEnergyRF = (int)manager.getCharge(energy) * 4;
                int toTransferRF = Math.round(Math.min(itemEnergyRF, max - stored));
                return new EnergyCharge((int)(manager.discharge(energy, toTransferRF, 4, false, false, false) * 4.0), energy, false);
            }
            if (SonarAPI.ic2Loaded() && energy.func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)energy.func_77973_b();
                IElectricItemManager manager = ElectricItem.manager;
                int itemEnergyRF = (int)manager.getCharge(energy) * 4;
                int toTransferRF = Math.round(Math.min(itemEnergyRF, energyStorage.getMaxEnergyStored() - stored));
                return new EnergyCharge((int)(manager.discharge(energy, toTransferRF, 4, false, false, false) * 4.0), energy, false);
            }
            if (stored + DischargeValues.getValueOf(energy) <= energyStorage.getMaxEnergyStored()) {
                return new EnergyCharge(DischargeValues.getValueOf(energy), energy, true);
            }
        }
        return new EnergyCharge(0, energy, false);
    }

    public static EnergyCharge charge(ItemStack energy, EnergyStorage energyStorage, int maxTransfer) {
        int max = energyStorage.getMaxEnergyStored();
        int stored = energyStorage.getEnergyStored();
        if (energy != null && stored > 0) {
            if (energy.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)energy.func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(energy)), (double)(item.getMaxEnergyStored(energy) - item.getEnergyStored(energy))));
                int toTransfer = Math.min(maxTransfer, Math.round(Math.min(itemEnergy, energyStorage.getEnergyStored())));
                return new EnergyCharge(-item.receiveEnergy(energy, toTransfer, false), energy, false);
            }
            if (SonarAPI.ic2Loaded() && energy.func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)energy.func_77973_b();
                IElectricItemManager manager = ElectricItem.manager;
                int itemEnergyRF = (int)Math.round(Math.min(Math.sqrt(item.getMaxCharge(energy) * 4.0), item.getMaxCharge(energy) * 4.0 - manager.getCharge(energy) * 4.0));
                int toTransferRF = Math.min(maxTransfer, Math.round(Math.min(itemEnergyRF, stored)));
                energyStorage.setEnergyStored((int)((double)stored - manager.charge(energy, toTransferRF / 4, 4, false, false) * 4.0));
                return new EnergyCharge(-((int)(manager.charge(energy, toTransferRF / 4, 4, false, false) * 4.0)), energy, false);
            }
            if (SonarAPI.ic2Loaded() && energy.func_77973_b() instanceof ISpecialElectricItem) {
                ISpecialElectricItem item = (ISpecialElectricItem)energy.func_77973_b();
                IElectricItemManager manager = item.getManager(energy);
                int itemEnergyRF = (int)Math.round(Math.min(Math.sqrt(item.getMaxCharge(energy) * 4.0), item.getMaxCharge(energy) * 4.0 - manager.getCharge(energy) * 4.0));
                int toTransferRF = Math.min(maxTransfer, Math.round(Math.min(itemEnergyRF, stored)));
                return new EnergyCharge(-((int)(manager.charge(energy, toTransferRF / 4, 4, false, false) * 4.0)), energy, false);
            }
        }
        return new EnergyCharge(0, energy, false);
    }
}

