/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.energy.ChargingUtils;
import sonar.core.energy.EnergyCharge;
import sonar.core.integration.SonarAPI;
import sonar.core.network.utils.ISyncTile;
import sonar.core.utils.helpers.NBTHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyEmitter", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2", striprefs=true)})
public abstract class TileEntitySidedInventorySender
extends TileEntitySidedInventory
implements IEnergyHandler,
IEnergySource,
ISyncTile {
    public EnergyStorage storage;
    public int maxTransfer = 5000;

    @Override
    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K && SonarAPI.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTHelper.readEnergyStorage(this.storage, nbt);
        }
        if (type == NBTHelper.SyncType.DROP) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTHelper.writeEnergyStorage(this.storage, nbt);
        }
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void discharge(int id) {
        EnergyCharge discharge;
        if (ChargingUtils.canDischarge(this.slots[id], this.storage) && (discharge = ChargingUtils.discharge(this.slots[id], this.storage)).getEnergyStack() != null && discharge.getEnergyUsage() != 0) {
            this.slots[id] = discharge.getEnergyStack();
            this.storage.modifyEnergyStored(discharge.getEnergyUsage());
            if (discharge.stackUsed()) {
                --this.slots[id].field_77994_a;
                if (this.slots[id].field_77994_a <= 0) {
                    this.slots[id] = null;
                }
            }
        }
    }

    public void charge(int id) {
        EnergyCharge charge;
        if (ChargingUtils.canCharge(this.slots[id], this.storage) && (charge = ChargingUtils.charge(this.slots[id], this.storage, this.maxTransfer)).getEnergyStack() != null && charge.getEnergyUsage() != 0) {
            this.slots[id] = charge.getEnergyStack();
            this.storage.modifyEnergyStored(charge.getEnergyUsage());
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && SonarAPI.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    public int getMaxItemTransfer() {
        return 4;
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.canConnectEnergy(direction);
    }

    @Override
    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return this.storage.extractEnergy(this.maxTransfer, true) / 4;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        this.storage.extractEnergy((int)(amount * 4.0), false);
    }

    @Override
    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }
}

