/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import cofh.api.energy.EnergyStorage;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.integration.SonarAPI;
import sonar.core.utils.helpers.NBTHelper;

public class TileEntityEnergy
extends TileEntitySonar
implements IEnergyTile {
    public EnergyStorage storage;
    public int maxTransfer;

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTHelper.readEnergyStorage(this.storage, nbt);
        }
        if (type == NBTHelper.SyncType.DROP) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTHelper.writeEnergyStorage(this.storage, nbt);
        }
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
    }

    @Override
    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K && SonarAPI.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && SonarAPI.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }
}

