/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.SonarAPI;
import sonar.core.utils.helpers.FontHelper;

public class SonarSeedsFood
extends ItemFood
implements IPlantable {
    private Block blockCrop;
    private Block soilId;
    public int greenhouseTier;

    public SonarSeedsFood(int hunger, float saturation, Block crop, Block soil, int tier) {
        super(hunger, saturation, false);
        this.blockCrop = crop;
        this.soilId = soil;
        this.greenhouseTier = tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (SonarAPI.calculatorLoaded()) {
            String mode = FontHelper.translate("calculator.tools.calculator.greenhouse");
            switch (this.greenhouseTier) {
                case 0: {
                    break;
                }
                case 1: {
                    list.add(FontHelper.translate("Planted with Basic Greenhouse or Higher"));
                    break;
                }
                case 2: {
                    list.add(FontHelper.translate("Planted with Advanced Greenhouse or Higher"));
                    break;
                }
                case 3: {
                    list.add(FontHelper.translate("Planted with Flawless Greenhouse"));
                }
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par, float f1, float f2, float f3) {
        if (this.greenhouseTier == 0 || !SonarAPI.calculatorLoaded()) {
            if (par != 1) {
                return false;
            }
            if (player.func_82247_a(x, y, z, par, stack) && player.func_82247_a(x, y + 1, z, par, stack)) {
                if (world.func_147439_a(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)this) && world.func_147437_c(x, y + 1, z)) {
                    world.func_147449_b(x, y + 1, z, this.blockCrop);
                    --stack.field_77994_a;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this.blockCrop;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public boolean canTierUse(int tier) {
        return tier >= this.greenhouseTier;
    }
}

