/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import cofh.api.block.IDismantleable;
import cofh.api.item.IToolHammer;
import cofh.api.tileentity.IReconfigurableSides;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import sonar.core.integration.SonarAPI;
import sonar.core.network.utils.ISyncTile;
import sonar.core.utils.IUpgradeCircuits;
import sonar.core.utils.helpers.NBTHelper;
import sonar.core.utils.helpers.SonarHelper;

public abstract class SonarBlock
extends Block
implements IDismantleable {
    protected Random rand = new Random();
    public boolean orientation;
    public boolean wrenchable;

    protected SonarBlock(Material material, boolean orientation) {
        super(material);
        this.orientation = orientation;
        this.wrenchable = true;
    }

    protected SonarBlock(Material material, boolean orientation, boolean wrenchable) {
        super(material);
        this.orientation = orientation;
        this.wrenchable = wrenchable;
    }

    public final boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitx, float hity, float hitz) {
        super.func_149727_a(world, x, y, z, player, side, hitx, hity, hitz);
        if (player != null) {
            ItemStack heldItem = player.func_70694_bm();
            if (this.wrenchable && heldItem != null && heldItem.func_77973_b() instanceof IToolHammer) {
                TileEntity target;
                if (!player.func_70093_af() && (target = world.func_147438_o(x, y, z)) instanceof IReconfigurableSides) {
                    ((IReconfigurableSides)target).incrSide(side);
                }
                return false;
            }
            if (this.wrenchable && SonarAPI.calculatorLoaded() && heldItem != null && (heldItem.func_77973_b() instanceof IToolHammer || heldItem.func_77973_b() == GameRegistry.findItem((String)"Calculator", (String)"Wrench"))) {
                return false;
            }
            return this.operateBlock(world, x, y, z, player, side, hitx, hity, hitz);
        }
        return false;
    }

    public final boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public abstract boolean dropStandard(World var1, int var2, int var3, int var4);

    public abstract boolean operateBlock(World var1, int var2, int var3, int var4, EntityPlayer var5, int var6, float var7, float var8, float var9);

    public final void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.dropStandard(world, x, y, z)) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getSpecialDrop(world, x, y, z)});
    }

    public final ItemStack getSpecialDrop(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof ISyncTile) {
            ItemStack itemStack = new ItemStack((Block)this, 1);
            this.processDrop(world, x, y, z, (ISyncTile)world.func_147438_o(x, y, z), itemStack);
            return itemStack;
        }
        ItemStack itemStack = new ItemStack((Block)this, 1);
        this.processDrop(world, x, y, z, null, itemStack);
        return itemStack;
    }

    public void processDrop(World world, int x, int y, int z, ISyncTile te, ItemStack drop) {
        if (te != null) {
            ISyncTile handler = te;
            NBTTagCompound tag = new NBTTagCompound();
            handler.writeData(tag, NBTHelper.SyncType.DROP);
            drop.func_77982_d(tag);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (this.orientation) {
            this.setDefaultDirection(world, x, y, z);
        }
    }

    public void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block b1 = world.func_147439_a(x, y, z - 1);
            Block b2 = world.func_147439_a(x, y, z + 1);
            Block b3 = world.func_147439_a(x - 1, y, z);
            Block b4 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (b1.func_149730_j() && !b2.func_149730_j()) {
                b0 = 3;
            }
            if (b2.func_149730_j() && !b1.func_149730_j()) {
                b0 = 2;
            }
            if (b3.func_149730_j() && !b4.func_149730_j()) {
                b0 = 5;
            }
            if (b4.func_149730_j() && !b3.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, x, b0, 2);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemstack) {
        TileEntity entity;
        if (this.orientation) {
            int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (l == 0) {
                world.func_72921_c(x, y, z, 2, 2);
            }
            if (l == 1) {
                world.func_72921_c(x, y, z, 5, 2);
            }
            if (l == 2) {
                world.func_72921_c(x, y, z, 3, 2);
            }
            if (l == 3) {
                world.func_72921_c(x, y, z, 4, 2);
            }
        }
        if (itemstack.func_77942_o() && (entity = world.func_147438_o(x, y, z)) != null && entity instanceof ISyncTile) {
            ISyncTile handler = (ISyncTile)entity;
            handler.readData(itemstack.func_77978_p(), NBTHelper.SyncType.DROP);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldblock, int oldMetadata) {
        IUpgradeCircuits tileentity;
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof IInventory) {
            tileentity = (IInventory)world.func_147438_o(x, y, z);
            for (int i = 0; i < tileentity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileentity.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = this.rand.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem item = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        item.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)item);
                }
            }
            world.func_147453_f(x, y, z, oldblock);
        }
        if (entity != null && entity instanceof IUpgradeCircuits) {
            tileentity = (IUpgradeCircuits)entity;
            float f = this.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
            if (tileentity.getUpgrades(0) > 0) {
                EntityItem speed = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(GameRegistry.findItem((String)"Calculator", (String)"SpeedUpgrade"), tileentity.getUpgrades(0)));
                world.func_72838_d((Entity)speed);
            }
            if (tileentity.getUpgrades(1) > 0) {
                EntityItem energy = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(GameRegistry.findItem((String)"Calculator", (String)"EnergyUpgrade"), tileentity.getUpgrades(1)));
                world.func_72838_d((Entity)energy);
            }
            if (tileentity.getUpgrades(2) > 0) {
                EntityItem energy = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(GameRegistry.findItem((String)"Calculator", (String)"VoidUpgrade"), tileentity.getUpgrades(2)));
                world.func_72838_d((Entity)energy);
            }
        }
        super.func_149749_a(world, x, y, z, oldblock, oldMetadata);
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        SonarHelper.dropTile(player, world.func_147439_a(x, y, z), world, x, y, z);
        return null;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public boolean hasSpecialRenderer() {
        return false;
    }

    public int func_149645_b() {
        return this.hasSpecialRenderer() ? -1 : 0;
    }

    public boolean func_149662_c() {
        return !this.hasSpecialRenderer();
    }

    public boolean func_149686_d() {
        return !this.hasSpecialRenderer();
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        list.add(AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G)));
        return list;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        if (this.hasSpecialCollisionBox()) {
            List<AxisAlignedBB> collisionList = this.getCollisionBoxes(world, x, y, z, new ArrayList<AxisAlignedBB>());
            for (AxisAlignedBB collision : collisionList) {
                collision.func_72317_d((double)x, (double)y, (double)z);
                if (collision == null || !collision.func_72326_a(axis)) continue;
                list.add(collision);
            }
        } else {
            super.func_149743_a(world, x, y, z, axis, list, entity);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public boolean hasSpecialCollisionBox() {
        return false;
    }
}

