/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.energy.DischargeValues;
import sonar.core.integration.SonarAPI;
import sonar.core.integration.SonarWailaModule;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketByteBufClient;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.PacketInventorySync;
import sonar.core.network.PacketMachineButton;
import sonar.core.network.PacketRequestSync;
import sonar.core.network.PacketSonarSides;
import sonar.core.network.PacketTextField;
import sonar.core.network.PacketTileSync;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.network.utils.ISyncTile;
import sonar.core.utils.helpers.NBTHelper;

@Mod(modid="SonarCore", name="SonarCore", version="1.0.3")
public class SonarCore {
    public static final String modid = "SonarCore";
    public static final String version = "1.0.3";
    @Mod.Instance(value="SonarCore")
    public static SonarCore instance;
    public static SimpleNetworkWrapper network;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Registering Packets");
        SonarCore.registerPackets();
        logger.info("Register Packets");
        DischargeValues.addValues();
        logger.info("Added Discharge Values");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (SonarAPI.wailaLoaded()) {
            SonarWailaModule.register();
            logger.info("Integrated with WAILA");
        } else {
            logger.warn("'WAILA' - unavailable or disabled in config");
        }
    }

    public static void registerPackets() {
        if (network == null) {
            network = NetworkRegistry.INSTANCE.newSimpleChannel("Sonar-Packets");
            network.registerMessage(PacketMachineButton.Handler.class, PacketMachineButton.class, 0, Side.SERVER);
            network.registerMessage(PacketTileSync.Handler.class, PacketTileSync.class, 1, Side.CLIENT);
            network.registerMessage(PacketSonarSides.Handler.class, PacketSonarSides.class, 2, Side.CLIENT);
            network.registerMessage(PacketInventorySync.Handler.class, PacketInventorySync.class, 3, Side.CLIENT);
            network.registerMessage(PacketRequestSync.Handler.class, PacketRequestSync.class, 4, Side.SERVER);
            network.registerMessage(PacketTextField.Handler.class, PacketTextField.class, 5, Side.SERVER);
            network.registerMessage(PacketByteBufClient.HandlerClient.class, PacketByteBufClient.class, 6, Side.CLIENT);
            network.registerMessage(PacketByteBufServer.HandlerServer.class, PacketByteBufServer.class, 7, Side.SERVER);
        }
    }

    public static void sendPacketAround(TileEntity tile, int spread, int id) {
        Object object = FMPHelper.checkObject(tile);
        if (object != null && object instanceof IByteBufTile) {
            if (!tile.func_145831_w().field_72995_K) {
                network.sendToAllAround((IMessage)new PacketByteBufClient((IByteBufTile)object, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, (double)spread));
            } else {
                network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)object, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id));
            }
        } else {
            TileHandler handler = FMPHelper.getHandler(object);
            if (handler != null && handler instanceof IByteBufTile) {
                if (!tile.func_145831_w().field_72995_K) {
                    network.sendToAllAround((IMessage)new PacketByteBufClient((IByteBufTile)((Object)handler), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, (double)spread));
                } else {
                    network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)((Object)handler), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id));
                }
            }
        }
    }

    public static void sendFullSyncAround(TileEntity tile, int spread) {
        Object object = FMPHelper.checkObject(tile);
        if (object != null && object instanceof ISyncTile) {
            NBTTagCompound tag = new NBTTagCompound();
            ((ISyncTile)object).writeData(tag, NBTHelper.SyncType.SYNC);
            if (!tag.func_82582_d()) {
                network.sendToAllAround((IMessage)new PacketTileSync(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tag), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, (double)spread));
            }
        }
    }

    static {
        logger = LogManager.getLogger((String)modid);
    }
}

