/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Safe;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersSafe;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.protection.PlayerPermissions;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersSafe
extends BlockCoverable {
    public static final String[] upgradeOres = new String[]{"ingotGold", "gemDiamond", "gemEmerald"};
    public static final ItemStack[] upgradeStack = new ItemStack[]{new ItemStack(Blocks.field_150340_R), new ItemStack(Blocks.field_150484_ah), new ItemStack(Blocks.field_150475_bE)};

    public BlockCarpentersSafe(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_safe_light = iconRegister.func_94245_a("CarpentersBlocks:safe/safe_light");
    }

    @Override
    protected boolean canPlayerActivate(TEBase TE, EntityPlayer entityPlayer) {
        if (PlayerPermissions.hasElevatedPermission(TE, entityPlayer)) {
            return true;
        }
        return !Safe.isLocked(TE);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int rot = EntityLivingUtil.getRotationValue((EntityLivingBase)entityPlayer);
        ForgeDirection dir = EntityLivingUtil.getRotationFacing(rot).getOpposite();
        if (dir != Safe.getFacing(TE)) {
            Safe.setFacing(TE, rot);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            boolean locked = !Safe.isLocked(TE);
            Safe.setLocked(TE, locked);
            if (locked) {
                Safe.setAutoPerm(TE, 0);
            } else {
                Safe.setAutoPerm(TE, 3);
            }
            if (locked) {
                ChatHandler.sendMessageToPlayer("message.safe_lock.name", entityPlayer);
            } else {
                ChatHandler.sendMessageToPlayer("message.safe_unlock.name", entityPlayer);
            }
            return true;
        }
        int autoPerm = Safe.getAutoPerm(TE);
        if (++autoPerm > 3) {
            autoPerm = 0;
        }
        Safe.setAutoPerm(TE, autoPerm);
        switch (autoPerm) {
            case 3: {
                ChatHandler.sendMessageToPlayer("message.automation_all.name", entityPlayer);
                break;
            }
            case 0: {
                ChatHandler.sendMessageToPlayer("message.automation_disabled.name", entityPlayer);
                break;
            }
            case 2: {
                ChatHandler.sendMessageToPlayer("message.automation_insert.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.automation_extract.name", entityPlayer);
            }
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            Safe.setFacing(TE, EntityLivingUtil.getRotationValue(entityLiving));
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    public static boolean isUpgrade(ItemStack itemStack) {
        return !BlockProperties.getOreDictMatch(itemStack, upgradeOres).equals("");
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        actionResult.setAltered();
        if (!Safe.isOpen(TE) && this.canPlayerActivate(TE, entityPlayer)) {
            ItemStack itemStack;
            if (entityPlayer.func_70093_af() && (itemStack = entityPlayer.func_70694_bm()) != null && BlockCarpentersSafe.isUpgrade(itemStack)) {
                if (!TE.hasAttribute((byte)25)) {
                    TE.addAttribute((byte)25, itemStack);
                    actionResult.decInventory().setSoundSource(itemStack);
                    return;
                }
            }
            if (!actionResult.decInv) {
                actionResult.setNoSound();
                entityPlayer.func_71007_a((IInventory)((TECarpentersSafe)TE));
            }
        } else {
            ChatHandler.sendMessageToPlayer("message.block_lock.name", entityPlayer);
        }
    }

    @Override
    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return Blocks.field_150357_h.func_149638_a(entity);
    }

    public boolean isSideSolid(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && this.isBlockSolid(blockAccess, x, y, z)) {
            return side != Safe.getFacing(TE);
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = super.getDrops(world, x, y, z, metadata, fortune);
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersSafe) {
            if (TE.hasAttribute((byte)25)) {
                ret.add(TE.getAttributeForDrop((byte)25));
            }
        }
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase tileEntity = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (tileEntity != null && tileEntity instanceof TECarpentersSafe) {
            TECarpentersSafe TE = (TECarpentersSafe)tileEntity;
            for (int idx = 0; idx < TE.func_70302_i_(); ++idx) {
                ItemStack itemStack = TE.func_70301_a(idx);
                if (itemStack == null) continue;
                this.func_149642_a(world, x, y, z, itemStack);
            }
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    @Override
    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && (Safe.isOpen(TE) || !PlayerPermissions.hasElevatedPermission(TE, entityPlayer))) {
            return -1.0f;
        }
        return super.func_149737_a(entityPlayer, world, x, y, z);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersSafe();
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersSafeRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            ForgeDirection direction = Safe.getFacing(cbTile);
            block0 : switch (axis) {
                case UP: {
                    switch (direction) {
                        case NORTH: {
                            Safe.setFacing(cbTile, 1);
                            break block0;
                        }
                        case EAST: {
                            Safe.setFacing(cbTile, 2);
                            break block0;
                        }
                        case WEST: {
                            Safe.setFacing(cbTile, 3);
                            break block0;
                        }
                        case SOUTH: {
                            Safe.setFacing(cbTile, 0);
                            break block0;
                        }
                    }
                    break;
                }
                case DOWN: {
                    switch (direction) {
                        case NORTH: {
                            Safe.setFacing(cbTile, 3);
                            break block0;
                        }
                        case EAST: {
                            Safe.setFacing(cbTile, 0);
                            break block0;
                        }
                        case SOUTH: {
                            Safe.setFacing(cbTile, 1);
                            break block0;
                        }
                        case WEST: {
                            Safe.setFacing(cbTile, 2);
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

