/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiAutoAnvil;
import openblocks.common.LiquidXpUtils;
import openblocks.common.container.ContainerAutoAnvil;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.gui.misc.IConfigurableGuiSlots;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableSides;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.MiscUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.VanillaAnvilLogic;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

public class TileEntityAutoAnvil
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
IConfigurableGuiSlots<AutoSlots>,
INeighbourAwareTile {
    protected static final int TOTAL_COOLDOWN = 40;
    public static final int TANK_CAPACITY = LiquidXpUtils.getLiquidForLevel(45);
    protected int cooldown = 0;
    private SyncableSides toolSides;
    private SyncableSides modifierSides;
    private SyncableSides outputSides;
    private SyncableSides xpSides;
    private SyncableTank tank;
    private SyncableFlags automaticSlots;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "autoanvil", true, 3){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            if (i == 0 && !itemstack.func_77973_b().func_77616_k(itemstack) && itemstack.func_77973_b() != Items.field_151134_bR) {
                return false;
            }
            if (i == 2) {
                return false;
            }
            return super.func_94041_b(i, itemstack);
        }
    });
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter slotSides = new SidedInventoryAdapter((IInventory)this.inventory);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Drain((IReadableBitMap)this.xpSides, (IFluidTank)this.tank);

    public TileEntityAutoAnvil() {
        this.slotSides.registerSlot((Enum)Slots.tool, (IReadableBitMap)this.toolSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.modifier, (IReadableBitMap)this.modifierSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.output, (IReadableBitMap)this.outputSides, false, true);
    }

    protected void createSyncedFields() {
        this.toolSides = new SyncableSides();
        this.modifierSides = new SyncableSides();
        this.outputSides = new SyncableSides();
        this.xpSides = new SyncableSides();
        this.tank = new SyncableTank(TANK_CAPACITY, new Fluid[]{OpenBlocks.Fluids.xpJuice});
        this.automaticSlots = SyncableFlags.create((int)AutoSlots.values().length);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                this.tank.fillFromSides(100, this.field_145850_b, this.getPosition(), this.xpSides.getValue());
            }
            if (this.shouldAutoOutput() && this.hasOutput()) {
                ItemDistribution.moveItemsToOneOfSides((TileEntity)this, (IInventory)this.inventory, (int)Slots.output.ordinal(), (int)1, (Iterable)this.outputSides.getValue(), (boolean)true);
            }
            if (this.shouldAutoInputTool() && !this.hasTool()) {
                ItemDistribution.moveItemsFromOneOfSides((TileEntity)this, (IInventory)this.inventory, (int)1, (int)Slots.tool.ordinal(), (Iterable)this.toolSides.getValue(), (boolean)true);
            }
            if (this.shouldAutoInputModifier()) {
                ItemDistribution.moveItemsFromOneOfSides((TileEntity)this, (IInventory)this.inventory, (int)1, (int)Slots.modifier.ordinal(), (Iterable)this.modifierSides.getValue(), (boolean)true);
            }
            if (this.cooldown-- < 0 && !this.hasOutput()) {
                this.repairItem();
                this.cooldown = 40;
            }
            if (this.tank.isDirty()) {
                this.sync();
            }
        }
    }

    private void repairItem() {
        int levelCost;
        int xpCost;
        int liquidXpCost;
        FluidStack drained;
        VanillaAnvilLogic helper = new VanillaAnvilLogic(this.inventory.getStackInSlot((Enum)Slots.tool), this.inventory.getStackInSlot((Enum)Slots.modifier));
        ItemStack output = helper.getOutputStack();
        if (output != null && (drained = this.tank.drain(liquidXpCost = LiquidXpUtils.xpToLiquidRatio(xpCost = EnchantmentUtils.getExperienceForLevel((int)(levelCost = helper.getLevelCost()))), false)) != null && drained.amount == liquidXpCost) {
            this.tank.drain(liquidXpCost, true);
            this.removeModifiers(helper.getModifierCost());
            this.inventory.func_70299_a(Slots.tool.ordinal(), null);
            this.inventory.func_70299_a(Slots.output.ordinal(), output);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.anvil_use", 0.3f, 1.0f);
        }
    }

    private void removeModifiers(int modifierCost) {
        if (modifierCost > 0) {
            ItemStack modifierStack = this.inventory.getStackInSlot((Enum)Slots.modifier);
            if (modifierStack != null) {
                modifierStack.field_77994_a -= modifierCost;
                if (modifierStack.field_77994_a <= 0) {
                    this.inventory.func_70299_a(Slots.modifier.ordinal(), null);
                }
            }
        } else {
            this.inventory.func_70299_a(Slots.modifier.ordinal(), null);
        }
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerAutoAnvil((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiAutoAnvil(new ContainerAutoAnvil((IInventory)player.field_71071_by, this));
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    private boolean shouldAutoInputModifier() {
        return this.automaticSlots.get((Enum)AutoSlots.modifier);
    }

    public boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    private boolean hasTool() {
        return this.inventory.func_70301_a(0) != null;
    }

    private boolean shouldAutoInputTool() {
        return this.automaticSlots.get((Enum)AutoSlots.tool);
    }

    private boolean hasOutput() {
        return this.inventory.func_70301_a(2) != null;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public IInventory getInventory() {
        return this.slotSides;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    private SyncableSides selectSlotMap(AutoSlots slot) {
        switch (slot) {
            case modifier: {
                return this.modifierSides;
            }
            case output: {
                return this.outputSides;
            }
            case tool: {
                return this.toolSides;
            }
            case xp: {
                return this.xpSides;
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    public IValueProvider<Set<ForgeDirection>> createAllowedDirectionsProvider(AutoSlots slot) {
        return this.selectSlotMap(slot);
    }

    public IWriteableBitMap<ForgeDirection> createAllowedDirectionsReceiver(AutoSlots slot) {
        SyncableSides dirs = this.selectSlotMap(slot);
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)dirs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<Boolean> createAutoFlagProvider(AutoSlots slot) {
        return BitMapUtils.singleBitProvider((IReadableBitMap)this.automaticSlots, (Object)slot.ordinal());
    }

    public IValueReceiver<Boolean> createAutoSlotReceiver(AutoSlots slot) {
        IRpcIntBitMap bits = (IRpcIntBitMap)this.createRpcProxy((ISyncableObject)this.automaticSlots, IRpcIntBitMap.class, new Class[0]);
        return BitMapUtils.singleBitReceiver((IRpcIntBitMap)bits, (int)slot.ordinal());
    }

    public void onNeighbourChanged(Block block) {
        this.tank.updateNeighbours(this.field_145850_b, this.getPosition());
    }

    public static enum AutoSlots {
        tool,
        modifier,
        output,
        xp;

    }

    public static enum Slots {
        tool,
        modifier,
        output;

    }
}

