/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import openblocks.common.entity.EntityHangGlider;
import openmods.renderer.DisplayListWrapper;
import org.lwjgl.opengl.GL11;

public class EntityHangGliderRenderer
extends Render {
    private static final float QUAD_HALF_SIZE = 2.4f;
    private static final float ONGROUND_ROTATION = 90.0f;
    private final DisplayListWrapper gliderRender = new DisplayListWrapper(){

        public void compile() {
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)2.4f, (float)0.0f, (float)2.4f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)-2.4f, (float)0.0f, (float)2.4f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)-2.4f, (float)0.0f, (float)-2.4f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)2.4f, (float)0.0f, (float)-2.4f);
            GL11.glEnd();
            GL11.glEnable((int)2884);
        }
    };
    private final ResourceLocation texture = new ResourceLocation("openblocks", "textures/models/hangglider.png");

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        EntityHangGlider glider = (EntityHangGlider)entity;
        EntityPlayer owner = glider.getPlayer();
        if (owner == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean isLocalPlayer = owner == minecraft.field_71439_g;
        boolean isFpp = minecraft.field_71474_y.field_74320_O == 0;
        boolean isDeployed = glider.isDeployed();
        if (isLocalPlayer && isFpp && isDeployed) {
            return;
        }
        float rotation = EntityHangGliderRenderer.interpolateRotation(glider.field_70126_B, glider.field_70177_z, f1);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(180.0f - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        if (isLocalPlayer) {
            if (isDeployed) {
                GL11.glTranslated((double)0.0, (double)-0.2, (double)0.3);
            } else if (isFpp) {
                GL11.glTranslated((double)0.0, (double)0.2, (double)0.0);
            } else {
                GL11.glTranslated((double)0.0, (double)-0.8, (double)-1.0);
            }
        } else if (isDeployed) {
            GL11.glTranslated((double)0.0, (double)0.2, (double)0.3);
        } else {
            GL11.glTranslated((double)0.0, (double)-0.5, (double)-1.0);
        }
        if (isDeployed) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.4f, (float)1.0f, (float)0.4f);
        }
        this.func_110776_a(this.texture);
        this.gliderRender.render();
        GL11.glPopMatrix();
    }

    private static float interpolateRotation(float prevRotation, float nextRotation, float modifier) {
        float rotation;
        for (rotation = nextRotation - prevRotation; rotation < -180.0f; rotation += 360.0f) {
        }
        while (rotation >= 180.0f) {
            rotation -= 360.0f;
        }
        return prevRotation + modifier * rotation;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.texture;
    }
}

