/*
 * Decompiled with CFR 0.152.
 */
package spatialiocompat;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import java.util.List;
import spatialiocompat.core.SIOCompatMarker;
import spatialiocompat.core.SIOModule;
import spatialiocompat.modules.BigReactors;
import spatialiocompat.modules.BloodMagic;
import spatialiocompat.modules.CarpenterBlocks;
import spatialiocompat.modules.IronChests;
import spatialiocompat.modules.Jabba;
import spatialiocompat.modules.OpenModsLib;
import spatialiocompat.modules.Thaumcraft;

@Mod(modid="spatialio-compat", name="Spatial IO Compat", version="build-9", dependencies="required-after:appliedenergistics2")
public class SIOCompat {
    public static final String MOD_ID = "spatialio-compat";
    public static final String MOD_NAME = "Spatial IO Compat";
    public static final String MOD_VERSION = "build-9";
    public static final String MOD_DEPENDENCIES = "required-after:appliedenergistics2";
    private final List<SIOModule> modules;

    public SIOCompat() {
        SIOCompatMarker marker = new SIOCompatMarker();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)marker);
        BigReactors bigReactors = new BigReactors(marker);
        BloodMagic bloodMagic = new BloodMagic(marker);
        CarpenterBlocks carpenterBlocks = new CarpenterBlocks(marker);
        IronChests ironChests = new IronChests(marker);
        Jabba jabba = new Jabba(marker);
        OpenModsLib openModsLib = new OpenModsLib(marker);
        Thaumcraft thaumcraft = new Thaumcraft(marker);
        this.modules = Lists.newArrayList((Object[])new SIOModule[]{bigReactors, bloodMagic, carpenterBlocks, ironChests, jabba, openModsLib, thaumcraft});
    }

    @Mod.EventHandler
    void initialization(FMLInitializationEvent event) {
        for (SIOModule module : this.modules) {
            if (!Loader.isModLoaded((String)module.getModID())) continue;
            module.register();
        }
    }
}

