/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.items;

import com.nauktis.core.utility.Color;
import com.nauktis.solarflux.blocks.SolarPanelBlock;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.utility.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class SolarPanelItemBlock
extends ItemBlock {
    public SolarPanelItemBlock(Block pBlock) {
        super(pBlock);
    }

    public void func_77624_a(ItemStack pItemStack, EntityPlayer pPlayer, List pList, boolean pBoolean) {
        super.func_77624_a(pItemStack, pPlayer, pList, pBoolean);
        SolarPanelBlock solar = (SolarPanelBlock)this.field_150939_a;
        this.addChargeTooltip(pList, pItemStack);
        this.addUpgradeCount(pList, pItemStack);
        this.addCapacityTooltip(pList, pItemStack, solar);
        this.addGenerationTooltip(pList, pItemStack, solar);
        this.addTransferTooltip(pList, pItemStack, solar);
    }

    private void addChargeTooltip(List pList, ItemStack pItemStack) {
        if (this.hasNbtTag(pItemStack, "SFEnergy")) {
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.GREEN, Lang.localise("energy.stored"), Color.GREY, pItemStack.func_77978_p().func_74762_e("SFEnergy")}));
        }
    }

    private void addUpgradeCount(List pList, ItemStack pItemStack) {
        if (this.hasNbtTag(pItemStack, "SFTLUpgradeCount")) {
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.GREEN, Lang.localise("upgrades.installed"), Color.GREY, pItemStack.func_77978_p().func_74762_e("SFTLUpgradeCount")}));
        }
    }

    private void addCapacityTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int itemValue;
        int value = ModConfiguration.getTierConfiguration(pSolar.getTierIndex()).getCapacity();
        if (this.hasNbtTag(pItemStack, "SFTLCapacity") && (itemValue = pItemStack.func_77978_p().func_74762_e("SFTLCapacity")) != value) {
            value = itemValue;
        }
        pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.capacity"), Color.GREY, value}));
    }

    private void addGenerationTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int value = ModConfiguration.getTierConfiguration(pSolar.getTierIndex()).getMaximumEnergyGeneration();
        pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.generation"), Color.GREY, value}));
    }

    private void addTransferTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int itemValue;
        int value = ModConfiguration.getTierConfiguration(pSolar.getTierIndex()).getMaximumEnergyTransfer();
        if (this.hasNbtTag(pItemStack, "SFTLTransferRate") && (itemValue = pItemStack.func_77978_p().func_74762_e("SFTLTransferRate")) != value) {
            value = itemValue;
        }
        pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.transfer"), Color.GREY, value}));
    }

    private boolean hasNbtTag(ItemStack pItemStack, String pNbtTag) {
        return pItemStack.func_77942_o() && pItemStack.func_77978_p().func_74764_b(pNbtTag);
    }
}

