/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.core.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BaseInventory
implements IInventory {
    private final String mInventoryName;
    private ItemStack[] mItemStacks;

    public BaseInventory(String pInventoryName, int pSize) {
        this.mInventoryName = pInventoryName;
        this.mItemStacks = new ItemStack[pSize];
    }

    public void writeToNBT(NBTTagCompound pNBT) {
        Preconditions.checkArgument((this.func_70302_i_() <= 127 ? 1 : 0) != 0, (Object)"Inventory size too big.");
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("SFSlot", (byte)i);
            itemStack.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        pNBT.func_74782_a("SFItems", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound pNBT) {
        NBTTagList tagList = pNBT.func_150295_c("SFItems", 10);
        this.mItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("SFSlot");
            this.func_70299_a(slotIndex, ItemStack.func_77949_a((NBTTagCompound)tagCompound));
        }
    }

    public int func_70302_i_() {
        return this.mItemStacks.length;
    }

    public boolean isEmpty() {
        return this.getOccupiedSlotsNumber() == 0;
    }

    public int getOccupiedSlotsNumber() {
        int count = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            ++count;
        }
        return count;
    }

    public ItemStack func_70301_a(int pSlotIndex) {
        return this.mItemStacks[pSlotIndex];
    }

    public ItemStack func_70298_a(int pSlotIndex, int pDecrementAmount) {
        ItemStack itemStack = this.func_70301_a(pSlotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= pDecrementAmount) {
                this.func_70299_a(pSlotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(pDecrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(pSlotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int pSlotIndex) {
        ItemStack itemStack = this.func_70301_a(pSlotIndex);
        if (itemStack != null) {
            this.func_70299_a(pSlotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int pSlotIndex, ItemStack pItemStack) {
        this.mItemStacks[pSlotIndex] = pItemStack;
        if (pItemStack != null && pItemStack.field_77994_a > this.func_70297_j_()) {
            pItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.mInventoryName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer pEntityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int pSlotIndex, ItemStack pItemStack) {
        return true;
    }
}

