/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.core.block.icon;

import com.nauktis.core.block.icon.IBlockIconHandler;
import java.util.Objects;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectedIconHandler
implements IBlockIconHandler {
    private final ForgeDirection[] SIDE_UP = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP};
    private final ForgeDirection[] SIDE_RIGHT = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.EAST, ForgeDirection.EAST, ForgeDirection.EAST, ForgeDirection.EAST};
    private final ForgeDirection[] SIDE_DOWN = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.DOWN, ForgeDirection.DOWN, ForgeDirection.DOWN, ForgeDirection.DOWN};
    private final ForgeDirection[] SIDE_LEFT = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.WEST};
    private final String mTextureBaseName;
    private final IIcon[] mIcons = new IIcon[16];

    public ConnectedIconHandler(String pModId, String pTextureName) {
        this.mTextureBaseName = String.format("%s:%s", Objects.requireNonNull(pModId).toLowerCase(), Objects.requireNonNull(pTextureName));
    }

    @Override
    public IIcon getIcon(int pSide, int pMetadata) {
        return this.mIcons[0];
    }

    @Override
    public IIcon getIcon(IBlockAccess pBlockAccess, int pX, int pY, int pZ, int pSide) {
        int textureIndex = 0;
        ForgeDirection neighborDirection = this.SIDE_UP[pSide];
        if (this.shouldConnect(pBlockAccess, pX, pY, pZ, pX + neighborDirection.offsetX, pY + neighborDirection.offsetY, pZ + neighborDirection.offsetZ)) {
            ++textureIndex;
        }
        neighborDirection = this.SIDE_RIGHT[pSide];
        if (this.shouldConnect(pBlockAccess, pX, pY, pZ, pX + neighborDirection.offsetX, pY + neighborDirection.offsetY, pZ + neighborDirection.offsetZ)) {
            textureIndex += 2;
        }
        neighborDirection = this.SIDE_DOWN[pSide];
        if (this.shouldConnect(pBlockAccess, pX, pY, pZ, pX + neighborDirection.offsetX, pY + neighborDirection.offsetY, pZ + neighborDirection.offsetZ)) {
            textureIndex += 4;
        }
        neighborDirection = this.SIDE_LEFT[pSide];
        if (this.shouldConnect(pBlockAccess, pX, pY, pZ, pX + neighborDirection.offsetX, pY + neighborDirection.offsetY, pZ + neighborDirection.offsetZ)) {
            textureIndex += 8;
        }
        return this.mIcons[textureIndex];
    }

    private boolean shouldConnect(IBlockAccess pBlockAccess, int pX, int pY, int pZ, int pCandidateX, int pCandidateY, int pCandidateZ) {
        return pBlockAccess.func_147439_a(pX, pY, pZ).equals(pBlockAccess.func_147439_a(pCandidateX, pCandidateY, pCandidateZ));
    }

    @Override
    public void registerBlockIcons(IIconRegister pIconRegister) {
        for (int i = 0; i < this.mIcons.length; ++i) {
            this.mIcons[i] = pIconRegister.func_94245_a(this.mTextureBaseName + i);
        }
    }
}

