/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import powercrystals.minefactoryreloaded.core.FruitHarvestManager;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFruitPicker;
import powercrystals.minefactoryreloaded.gui.container.ContainerFruitPicker;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFruitPicker
extends TileEntityFactoryPowered {
    private IHarvestManager _treeManager;
    private Random _rand;

    public TileEntityFruitPicker() {
        super(Machine.FruitPicker);
        TileEntityFruitPicker.createHAM(this, 1);
        this._rand = new Random();
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            this._treeManager = new FruitHarvestManager(this.field_145850_b, new Area(new BlockPosition((TileEntity)this), 0, 0, 0), HarvestMode.FruitTree);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ContainerFruitPicker getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFruitPicker(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFruitPicker(this.getContainer(inventoryPlayer), this);
    }

    @Override
    protected boolean activateMachine() {
        BlockPosition blockPosition = this.getNextTree();
        if (blockPosition == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        int n = this.field_145850_b.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        IFactoryFruit iFactoryFruit = MFRRegistry.getFruits().get(block);
        List<ItemStack> list = iFactoryFruit.getDrops(this.field_145850_b, this._rand, blockPosition.x, blockPosition.y, blockPosition.z);
        ReplacementBlock replacementBlock = iFactoryFruit.getReplacementBlock(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z);
        iFactoryFruit.prePick(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z);
        if (replacementBlock == null) {
            if (!this.field_145850_b.func_147468_f(blockPosition.x, blockPosition.y, blockPosition.z)) {
                return false;
            }
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_145850_b.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, Block.func_149682_b((Block)block) + (n << 12));
            }
        } else if (!replacementBlock.replaceBlock(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, null)) {
            return false;
        }
        this.doDrop(list);
        iFactoryFruit.postPick(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z);
        return true;
    }

    private BlockPosition getNextTree() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        if (!this.field_145850_b.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z)) {
            return null;
        }
        Block block = this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getFruitLogBlocks().contains(block)) {
            IFactoryFruit iFactoryFruit = MFRRegistry.getFruits().get(block);
            return iFactoryFruit != null && iFactoryFruit.canBePicked(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z) ? blockPosition : null;
        }
        BlockPosition blockPosition2 = this.getNextTreeSegment(blockPosition);
        if (blockPosition2 != null) {
            this._areaManager.rewindBlock();
        }
        return blockPosition2;
    }

    private BlockPosition getNextTreeSegment(BlockPosition blockPosition) {
        Area area;
        if (this._treeManager.getIsDone() || !this._treeManager.getOrigin().equals(blockPosition)) {
            int n = 0;
            int n2 = MFRConfig.fruitTreeSearchMaxVertical.getInt();
            area = new Area(blockPosition.copy(), MFRConfig.fruitTreeSearchMaxHorizontal.getInt(), n, n2);
            this._treeManager.reset(this.field_145850_b, area, HarvestMode.FruitTree, null);
        }
        Map<Block, IFactoryFruit> map = MFRRegistry.getFruits();
        while (!this._treeManager.getIsDone()) {
            BlockPosition blockPosition2 = this._treeManager.getNextBlock();
            Block block = this.field_145850_b.func_147439_a(blockPosition2.x, blockPosition2.y, blockPosition2.z);
            IFactoryFruit iFactoryFruit = area = map.containsKey(block) ? map.get(block) : null;
            if (area != null && area.canBePicked(this.field_145850_b, blockPosition2.x, blockPosition2.y, blockPosition2.z)) {
                return blockPosition2;
            }
            this._treeManager.moveNext();
        }
        return null;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0 && this.isUsableAugment(itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public int getUpgradeSlot() {
        return 0;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return this.getDirectionFacing().getOpposite();
    }
}

