/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup.recipe;

import cofh.api.modhelpers.ThermalExpansionHelper;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.setup.recipe.Vanilla;

public class ThermalExpansion
extends Vanilla {
    private static final String TE = "ThermalExpansion";
    private static final String TF = "ThermalFoundation";
    ItemStack conduitLiquid;
    ItemStack tankBasic;
    ItemStack tankReinforced;
    ItemStack lamp;
    ItemStack machineFrame;
    ItemStack pneumaticServo;
    ItemStack powerCoilElectrum;
    ItemStack powerCoilGold;
    ItemStack powerCoilSilver;
    ItemStack tesseractFrameFull;
    ItemStack strongBox;
    ItemStack strongBoxBasic;
    ItemStack sulfur;
    ItemStack multimeter;
    ItemStack invarAxe;
    ItemStack invarSword;
    ItemStack invarPickaxe;
    ItemStack invarShovel;
    ItemStack dynamoSteam;
    ItemStack tesseract;
    ItemStack tesseractFrameEmpty;
    ItemStack cellResonant;
    ItemStack cellRedstone;
    ItemStack igniter;

    @Override
    protected void gatherItems() {
        if (!Loader.isModLoaded((String)TE)) {
            MineFactoryReloadedCore.log().fatal("ThermalExpansion is required for ThermalExpansion recipes to be enabled.");
            throw new MissingModsException(Collections.singleton(new DefaultArtifactVersion(TE)));
        }
        this.conduitLiquid = new ItemStack((Block)MFRThings.plasticPipeBlock);
        this.tankBasic = GameRegistry.findItemStack((String)TE, (String)"tankBasic", (int)1);
        this.tankReinforced = GameRegistry.findItemStack((String)TE, (String)"tankReinforced", (int)1);
        this.lamp = GameRegistry.findItemStack((String)TE, (String)"illuminator", (int)1);
        this.machineFrame = new ItemStack(GameRegistry.findBlock((String)TE, (String)"Frame"), 1, 0);
        this.strongBox = GameRegistry.findItemStack((String)TE, (String)"strongboxReinforced", (int)1);
        this.strongBoxBasic = GameRegistry.findItemStack((String)TE, (String)"strongboxBasic", (int)1);
        this.dynamoSteam = GameRegistry.findItemStack((String)TE, (String)"dynamoSteam", (int)1);
        this.tesseract = new ItemStack(GameRegistry.findBlock((String)TE, (String)"Tesseract"), 1, 0);
        this.tesseractFrameEmpty = new ItemStack(GameRegistry.findBlock((String)TE, (String)"Frame"), 1, 7);
        this.tesseractFrameFull = new ItemStack(GameRegistry.findBlock((String)TE, (String)"Frame"), 1, 8);
        this.cellResonant = GameRegistry.findItemStack((String)TE, (String)"cellResonant", (int)1);
        this.cellRedstone = GameRegistry.findItemStack((String)TE, (String)"cellReinforced", (int)1);
        this.pneumaticServo = GameRegistry.findItemStack((String)TE, (String)"pneumaticServo", (int)1);
        this.powerCoilElectrum = GameRegistry.findItemStack((String)TE, (String)"powerCoilElectrum", (int)1);
        this.powerCoilGold = GameRegistry.findItemStack((String)TE, (String)"powerCoilGold", (int)1);
        this.powerCoilSilver = GameRegistry.findItemStack((String)TE, (String)"powerCoilSilver", (int)1);
        this.multimeter = GameRegistry.findItemStack((String)TE, (String)"multimeter", (int)1);
        this.igniter = GameRegistry.findItemStack((String)TE, (String)"igniter", (int)1);
        this.invarAxe = GameRegistry.findItemStack((String)TF, (String)"toolInvarAxe", (int)1);
        this.invarSword = GameRegistry.findItemStack((String)TF, (String)"toolInvarSword", (int)1);
        this.invarPickaxe = GameRegistry.findItemStack((String)TF, (String)"toolInvarPickaxe", (int)1);
        this.invarShovel = GameRegistry.findItemStack((String)TF, (String)"toolInvarShovel", (int)1);
        this.sulfur = GameRegistry.findItemStack((String)TF, (String)"dustSulfur", (int)1);
    }

    @Override
    protected void registerMachines() {
        String string = "ingot";
        string = "thermalexpansion:machine";
        this.registerMachine(Machine.Planter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151162_bE, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Copper", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Fisher, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151112_aM, Character.valueOf('S'), Items.field_151133_ar, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Iron", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Harvester, "PSP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('T'), this.invarAxe, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Gold", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Rancher, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.conduitLiquid, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Tin", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Fertilizer, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151069_bo, Character.valueOf('S'), Items.field_151116_aA, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Nickel", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Vet, "PTP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), MFRThings.syringeEmptyItem, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Copper", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.ItemCollector, 8, new Object[]{"P P", " F ", "PCP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('F'), this.machineFrame, Character.valueOf('C'), Blocks.field_150486_ae});
        this.registerMachine(Machine.BlockBreaker, "PTP", "SFA", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), "gearInvar", Character.valueOf('S'), this.invarPickaxe, Character.valueOf('F'), this.machineFrame, Character.valueOf('A'), this.invarShovel, Character.valueOf('O'), string + "Iron", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.WeatherCollector, "PBP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Copper", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.SludgeBoiler, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('S'), Blocks.field_150460_al, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Iron", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Sewer, 4, new Object[]{"PTP", "SFS", "SQS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('S'), Items.field_151118_aC, Character.valueOf('F'), this.machineFrame, Character.valueOf('Q'), this.pneumaticServo});
        this.registerMachine(Machine.Composter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150460_al, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), Items.field_151118_aC, Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Breeder, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151153_ao, Character.valueOf('S'), Items.field_151150_bK, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), "dyePurple", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Grinder, "PTP", "OFO", "SCS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.invarSword, Character.valueOf('O'), Items.field_151122_aG, Character.valueOf('F'), this.machineFrame, Character.valueOf('S'), string + "Tin", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.AutoEnchanter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150343_Z, Character.valueOf('S'), Items.field_151122_aG, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), "gemDiamond", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Chronotyper, "PTP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), "gemEmerald", Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), "dyePurple", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Ejector, 8, new Object[]{"PPP", " T ", "OFO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.pneumaticServo, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), "dustRedstone"});
        this.registerMachine(Machine.ItemRouter, 8, new Object[]{"PTP", "SFS", "PSP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150486_ae, Character.valueOf('S'), this.multimeter, Character.valueOf('F'), this.machineFrame});
        this.registerMachine(Machine.LiquidRouter, 8, new Object[]{"PTP", "SFS", "PSP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.conduitLiquid, Character.valueOf('S'), this.multimeter, Character.valueOf('F'), this.machineFrame});
        int n = MFRConfig.craftSingleDSU.getBoolean(false) ? 1 : 4;
        this.registerMachine(Machine.DeepStorageUnit, n, new Object[]{"PCP", "CFC", "PCP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), this.strongBox, Character.valueOf('F'), this.tesseractFrameFull});
        if (MFRConfig.enableCheapDSU.getBoolean(false)) {
            this.registerMachine(Machine.DeepStorageUnit, "PCP", "CFC", "PCP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), this.strongBoxBasic, Character.valueOf('F'), this.machineFrame);
        }
        this.registerMachine(Machine.LiquiCrafter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('S'), this.tankBasic, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), Items.field_151122_aG, Character.valueOf('C'), this.pneumaticServo);
        this.registerMachine(Machine.LavaFabricator, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150343_Z, Character.valueOf('S'), Items.field_151064_bs, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), Items.field_151072_bj, Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.SteamBoiler, "PPP", "TBT", "SSS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.tankReinforced, Character.valueOf('B'), Machine.SludgeBoiler.getItemStack(), Character.valueOf('S'), Blocks.field_150387_bl);
        this.registerMachine(Machine.AutoJukebox, "PJP", "PFP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('J'), Blocks.field_150421_aI, Character.valueOf('F'), this.machineFrame);
        this.registerMachine(Machine.Unifier, "PTP", "OFO", "SCS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.multimeter, Character.valueOf('O'), Items.field_151132_bS, Character.valueOf('F'), this.machineFrame, Character.valueOf('S'), string + "Silver", Character.valueOf('C'), Items.field_151122_aG);
        this.registerMachine(Machine.AutoSpawner, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151075_bm, Character.valueOf('S'), Items.field_151064_bs, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), "gemEmerald", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.BioReactor, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151071_bq, Character.valueOf('S'), "slimeball", Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), Items.field_151118_aC, Character.valueOf('C'), Items.field_151102_aT);
        this.registerMachine(Machine.BioFuelGenerator, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150460_al, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), Items.field_151072_bj, Character.valueOf('C'), this.powerCoilSilver);
        this.registerMachine(Machine.AutoDisenchanter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150385_bj, Character.valueOf('S'), Items.field_151122_aG, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), "gemDiamond", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.Slaughterhouse, "GIG", "SFS", "XCX", Character.valueOf('G'), "sheetPlastic", Character.valueOf('S'), this.invarSword, Character.valueOf('X'), this.invarAxe, Character.valueOf('I'), "gearInvar", Character.valueOf('F'), this.machineFrame, Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.MeatPacker, "GSG", "BFB", "BCB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150336_V, Character.valueOf('S'), this.igniter, Character.valueOf('F'), this.machineFrame, Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.EnchantmentRouter, "PBP", "SFS", "PSP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('S'), Items.field_151107_aW, Character.valueOf('F'), this.machineFrame);
        this.registerMachine(Machine.LaserDrill, "GFG", "CFC", "DHD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), "gemDiamond", Character.valueOf('H'), "blockGlassHardened", Character.valueOf('F'), this.lamp, Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.LaserDrillPrecharger, "GSG", "HFH", "CDC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack(MFRThings.pinkSlimeItem, 1, 1), Character.valueOf('H'), "blockGlassHardened", Character.valueOf('F'), this.lamp, Character.valueOf('C'), this.powerCoilElectrum);
        this.registerMachine(Machine.AutoAnvil, "GGG", "AFA", "OCO", Character.valueOf('G'), "sheetPlastic", Character.valueOf('A'), Blocks.field_150467_bQ, Character.valueOf('F'), this.machineFrame, Character.valueOf('C'), this.powerCoilGold, Character.valueOf('O'), string + "Iron");
        this.registerMachine(Machine.BlockSmasher, "GPG", "HFH", "BCB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('H'), MFRThings.factoryHammerItem, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('F'), this.machineFrame, Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.RedNote, "GNG", "CFC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), "cableRedNet", Character.valueOf('N'), Blocks.field_150323_B, Character.valueOf('F'), this.machineFrame);
        this.registerMachine(Machine.AutoBrewer, "GBG", "CFC", "RPR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), this.conduitLiquid, Character.valueOf('B'), Items.field_151067_bt, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('F'), this.machineFrame, Character.valueOf('P'), this.powerCoilGold);
        this.registerMachine(Machine.FruitPicker, "GXG", "SFS", "OCO", Character.valueOf('G'), "sheetPlastic", Character.valueOf('X'), this.invarAxe, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('F'), this.machineFrame, Character.valueOf('C'), this.powerCoilGold, Character.valueOf('O'), string + "Tin");
        this.registerMachine(Machine.BlockPlacer, "GDG", "DMD", "GSG", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('S'), this.powerCoilGold, Character.valueOf('M'), this.machineFrame);
        this.registerMachine(Machine.MobCounter, "GGG", "RCR", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('S'), this.multimeter, Character.valueOf('M'), this.machineFrame);
        this.registerMachine(Machine.SteamTurbine, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.dynamoSteam, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Silver", Character.valueOf('C'), this.powerCoilSilver);
        this.registerMachine(Machine.ChunkLoader, "PEP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.tesseract, Character.valueOf('E'), this.cellResonant, Character.valueOf('F'), this.tesseractFrameEmpty, Character.valueOf('O'), string + "Electrum", Character.valueOf('C'), this.powerCoilElectrum);
        if (MFRConfig.enableCheapCL.getBoolean(false)) {
            this.registerMachine(Machine.ChunkLoader, "PEP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.tesseractFrameEmpty, Character.valueOf('E'), this.cellRedstone, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Electrum", Character.valueOf('C'), this.powerCoilElectrum);
        }
        this.registerMachine(Machine.Fountain, "PBP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('T'), this.tankBasic, Character.valueOf('F'), this.machineFrame, Character.valueOf('O'), string + "Nickel", Character.valueOf('C'), this.powerCoilGold);
        this.registerMachine(Machine.MobRouter, "PPP", "BRB", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('R'), Machine.ItemRouter.getItemStack(), Character.valueOf('O'), "dyeOrange", Character.valueOf('C'), Machine.Chronotyper.getItemStack());
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.plasticTank, (int)1), (Object[])new Object[]{"PPP", "P P", "PMP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('M'), MFRThings.machineBaseItem}));
    }

    @Override
    protected void registerSmelting() {
        super.registerSmelting();
        ThermalExpansionHelper.addSmelterRecipe((int)2000, (ItemStack)ItemHelper.stack((Item)MFRThings.rawRubberItem, (int)2), (ItemStack)this.sulfur, (ItemStack)ItemHelper.stack((Item)MFRThings.rubberBarItem, (int)4), (ItemStack)ItemHelper.stack((Item)MFRThings.rubberBarItem, (int)1), (int)45);
    }

    @Override
    protected void registerMiscItems() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.fertilizerItem, 24), new Object[]{"WBW", "STS", "WBW", Character.valueOf('W'), Items.field_151015_O, Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 15), Character.valueOf('S'), "dustSulfur", Character.valueOf('T'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.spyglassItem), new Object[]{"GLG", "PLP", " S ", Character.valueOf('G'), "ingotBronze", Character.valueOf('L'), "blockGlass", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stickWood"}));
        if (MFRConfig.enablePortaSpawner.getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.portaSpawnerItem), new Object[]{"GLG", "DND", "GLG", Character.valueOf('G'), "ingotInvar", Character.valueOf('L'), "blockGlass", Character.valueOf('D'), "ingotEnderium", Character.valueOf('N'), Items.field_151156_bN}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.detCordBlock, 12), new Object[]{"PPP", "PTP", "PPP", Character.valueOf('P'), "itemRubber", Character.valueOf('T'), Blocks.field_150335_W}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.fishingRodItem, 1), new Object[]{"DD ", "DFD", "TDD", Character.valueOf('D'), "wireExplosive", Character.valueOf('F'), Items.field_151112_aM, Character.valueOf('T'), Blocks.field_150429_aA}));
    }

    @Override
    protected void registerRedNet() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MFRThings.rednetCableBlock, 8), new Object[]{"PPP", "RRR", "PPP", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "sheetPlastic"}));
        ItemStack itemStack = ItemHelper.stack((Block)MFRThings.plasticPipeBlock);
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)5), (Object[])new Object[]{itemStack, itemStack, itemStack, itemStack, itemStack, "dustRedstone", "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)MFRThings.rednetCableBlock, 1, 2), new Object[]{"nuggetElectrum", "nuggetElectrum", "nuggetElectrum", "dustRedstone", "dustRedstone", new ItemStack((Block)MFRThings.rednetCableBlock)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)MFRThings.rednetCableBlock, 6, 2), new Object[]{"ingotElectrum", "ingotElectrum", Blocks.field_150451_bX, new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.machineItem, 1, 1), new Object[]{"PRP", "RGR", "PIP", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MFRThings.rednetLogicBlock), new Object[]{"RDR", "LGL", "PHP", Character.valueOf('H'), new ItemStack(MFRThings.machineItem, 1, 1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "gemLapis", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.logicCardItem, 1, 0), new Object[]{"RPR", "PGP", "RPR", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.logicCardItem, 1, 1), new Object[]{"GPG", "PCP", "RGR", Character.valueOf('C'), new ItemStack(MFRThings.logicCardItem, 1, 0), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.logicCardItem, 1, 2), new Object[]{"DPD", "RCR", "GDG", Character.valueOf('C'), new ItemStack(MFRThings.logicCardItem, 1, 1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.rednetMeterItem, 1, 0), new Object[]{" G", "PR", "PP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetElectrum", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.rednetMeterItem, 1, 1), new Object[]{"RGR", "IMI", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), this.powerCoilElectrum, Character.valueOf('I'), "ingotCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), new ItemStack(MFRThings.rednetMeterItem, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.rednetMemoryCardItem, 1, 0), new Object[]{"GGG", "PRP", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MFRThings.rednetPanelBlock, 1, 0), new Object[]{"PCP", "PBP", "KPK", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), MFRThings.rednetCableBlock, Character.valueOf('B'), Blocks.field_150342_X, Character.valueOf('K'), new ItemStack(Items.field_151100_aR, 1, 0)}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MFRThings.rednetMemoryCardItem, 1, 0), (Object[])new Object[]{new ItemStack(MFRThings.rednetMemoryCardItem, 1, 0)});
    }
}

