/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded;

import cofh.lib.render.RenderFluidOverlayItem;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Point;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.block.fluid.BlockFactoryFluid;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.entity.DebugTracker;
import powercrystals.minefactoryreloaded.entity.EntityFishingRod;
import powercrystals.minefactoryreloaded.entity.EntityNeedle;
import powercrystals.minefactoryreloaded.entity.EntityPinkSlime;
import powercrystals.minefactoryreloaded.entity.EntityRocket;
import powercrystals.minefactoryreloaded.entity.EntitySafariNet;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoBrewer;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoDisenchanter;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoJukebox;
import powercrystals.minefactoryreloaded.gui.container.ContainerFisher;
import powercrystals.minefactoryreloaded.gui.slot.SlotAcceptLaserFocus;
import powercrystals.minefactoryreloaded.gui.slot.SlotAcceptReusableSafariNet;
import powercrystals.minefactoryreloaded.item.gun.ItemRocketLauncher;
import powercrystals.minefactoryreloaded.render.block.BlockTankRenderer;
import powercrystals.minefactoryreloaded.render.block.ConveyorRenderer;
import powercrystals.minefactoryreloaded.render.block.DetCordRenderer;
import powercrystals.minefactoryreloaded.render.block.FactoryGlassPaneRenderer;
import powercrystals.minefactoryreloaded.render.block.FactoryGlassRenderer;
import powercrystals.minefactoryreloaded.render.block.PlasticPipeRenderer;
import powercrystals.minefactoryreloaded.render.block.RedNetCableRenderer;
import powercrystals.minefactoryreloaded.render.block.RedNetLogicRenderer;
import powercrystals.minefactoryreloaded.render.block.VineScaffoldRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityDebugTrackerRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityNeedleRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityPinkSlimeRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityRocketRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntitySafariNetRenderer;
import powercrystals.minefactoryreloaded.render.item.ConveyorItemRenderer;
import powercrystals.minefactoryreloaded.render.item.FactoryGlassPaneItemRenderer;
import powercrystals.minefactoryreloaded.render.item.NeedleGunItemRenderer;
import powercrystals.minefactoryreloaded.render.item.PotatoLauncherItemRenderer;
import powercrystals.minefactoryreloaded.render.item.RocketItemRenderer;
import powercrystals.minefactoryreloaded.render.item.RocketLauncherItemRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.LaserDrillPrechargerRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.LaserDrillRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.RedNetCardItemRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.RedNetHistorianRenderer;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrillPrecharger;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetHistorian;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

@SideOnly(value=Side.CLIENT)
public class MineFactoryReloadedClient
implements IResourceManagerReloadListener {
    public static MineFactoryReloadedClient instance;
    private static final ResourceLocation targetingBlue;
    private static final ResourceLocation targetingRed;
    private static final int _lockonMax = 30;
    private static final int _lockonLostMax = 60;
    private int _lockonTicks = 0;
    private int _lockonLostTicks = 0;
    private Entity _lastEntityOver = null;
    private static boolean gl14;
    public static HashMap<BlockPosition, Integer> prcPages;
    public static Set<IHarvestAreaContainer> _areaTileEntities;

    public static void init() {
        instance = new MineFactoryReloadedClient();
        MineFactoryReloadedCore.renderIdConveyor = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFactoryGlassPane = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFluidTank = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFluidClassic = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdRedNetLogic = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdVineScaffold = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFactoryGlass = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdDetCord = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdRedNet = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdPPipe = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdConveyor, (ISimpleBlockRenderingHandler)new ConveyorRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdFactoryGlassPane, (ISimpleBlockRenderingHandler)new FactoryGlassPaneRenderer());
        BlockTankRenderer blockTankRenderer = new BlockTankRenderer();
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdFluidTank, (ISimpleBlockRenderingHandler)blockTankRenderer);
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdVineScaffold, (ISimpleBlockRenderingHandler)new VineScaffoldRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdFactoryGlass, (ISimpleBlockRenderingHandler)new FactoryGlassRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdDetCord, (ISimpleBlockRenderingHandler)new DetCordRenderer());
        RedNetCableRenderer redNetCableRenderer = new RedNetCableRenderer();
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdRedNet, (ISimpleBlockRenderingHandler)redNetCableRenderer);
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdPPipe, (ISimpleBlockRenderingHandler)new PlasticPipeRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdRedNetLogic, (ISimpleBlockRenderingHandler)new RedNetLogicRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetLogic.class, (TileEntitySpecialRenderer)new powercrystals.minefactoryreloaded.render.tileentity.RedNetLogicRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MFRThings.conveyorBlock), (IItemRenderer)new ConveyorItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MFRThings.factoryGlassPaneBlock), (IItemRenderer)new FactoryGlassPaneItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MFRThings.plasticTank), (IItemRenderer)blockTankRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.logicCardItem, (IItemRenderer)new RedNetCardItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.needlegunItem, (IItemRenderer)new NeedleGunItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.rocketItem, (IItemRenderer)new RocketItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.rocketLauncherItem, (IItemRenderer)new RocketLauncherItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.potatoLauncherItem, (IItemRenderer)new PotatoLauncherItemRenderer());
        RenderFluidOverlayItem renderFluidOverlayItem = new RenderFluidOverlayItem();
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.plasticCupItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.sewageBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.sludgeBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.mobEssenceBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.bioFuelBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.meatBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.pinkSlimeBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.chocolateMilkBucketItem, (IItemRenderer)renderFluidOverlayItem);
        MinecraftForgeClient.registerItemRenderer((Item)MFRThings.mushroomSoupBucketItem, (IItemRenderer)renderFluidOverlayItem);
        if (MFRThings.syringeEmptyItem instanceof IFluidContainerItem) {
            MinecraftForgeClient.registerItemRenderer((Item)MFRThings.syringeEmptyItem, (IItemRenderer)new RenderFluidOverlayItem(false));
        }
        RedNetHistorianRenderer redNetHistorianRenderer = new RedNetHistorianRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetHistorian.class, (TileEntitySpecialRenderer)redNetHistorianRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)redNetHistorianRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetCable.class, (TileEntitySpecialRenderer)redNetCableRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetEnergy.class, (TileEntitySpecialRenderer)redNetCableRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserDrill.class, (TileEntitySpecialRenderer)new LaserDrillRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserDrillPrecharger.class, (TileEntitySpecialRenderer)new LaserDrillPrechargerRenderer());
        RenderingRegistry.registerEntityRenderingHandler(DebugTracker.class, (Render)new EntityDebugTrackerRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntitySafariNet.class, (Render)new EntitySafariNetRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityPinkSlime.class, (Render)new EntityPinkSlimeRenderer((ModelBase)new ModelSlime(16), (ModelBase)new ModelSlime(0), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntityNeedle.class, (Render)new EntityNeedleRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityRocket.class, (Render)new EntityRocketRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityFishingRod.class, (Render)new RenderSnowball(MFRThings.fishingRodItem));
        VillagerRegistry.instance().registerVillagerSkin(MFRConfig.zoolologistEntityId.getInt(), new ResourceLocation("minefactoryreloaded:textures/villager/zoologist.png"));
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
        gl14 = GLContext.getCapabilities().OpenGL14;
        IReloadableResourceManager iReloadableResourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        iReloadableResourceManager.func_110542_a((IResourceManagerReloadListener)instance);
    }

    public void func_110549_a(IResourceManager iResourceManager) {
        NeedleGunItemRenderer.updateModel();
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre pre) {
        switch (pre.map.func_130086_a()) {
            case 1: {
                SlotAcceptReusableSafariNet.background = pre.map.func_94245_a("minefactoryreloaded:gui/reusablenet");
                ContainerAutoDisenchanter.background = pre.map.func_94245_a("minefactoryreloaded:gui/book");
                ContainerAutoJukebox.background = pre.map.func_94245_a("minefactoryreloaded:gui/record");
                SlotAcceptLaserFocus.background = pre.map.func_94245_a("minefactoryreloaded:gui/laserfocus");
                ContainerAutoBrewer.ingredient = pre.map.func_94245_a("minefactoryreloaded:gui/netherwart");
                ContainerAutoBrewer.bottle = pre.map.func_94245_a("minefactoryreloaded:gui/bottle");
                ContainerFisher.background = pre.map.func_94245_a("minefactoryreloaded:gui/fishingrod");
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPostTextureStitch(TextureStitchEvent.Post post) {
        switch (post.map.func_130086_a()) {
            case 0: {
                this.setIcons("milk", MFRThings.milkLiquid);
                this.setIcons("sludge", MFRThings.sludgeLiquid);
                this.setIcons("sewage", MFRThings.sewageLiquid);
                this.setIcons("mobessence", MFRThings.essenceLiquid);
                this.setIcons("biofuel", MFRThings.biofuelLiquid);
                this.setIcons("meat", MFRThings.meatLiquid);
                this.setIcons("pinkslime", MFRThings.pinkSlimeLiquid);
                this.setIcons("chocolatemilk", MFRThings.chocolateMilkLiquid);
                this.setIcons("mushroomsoup", MFRThings.mushroomSoupLiquid);
                this.setIcons("steam", MFRThings.steamFluid);
                break;
            }
        }
    }

    private void setIcons(String string, BlockFactoryFluid blockFactoryFluid) {
        Fluid fluid = FluidRegistry.getFluid((String)string);
        if (fluid.getBlock().equals(blockFactoryFluid)) {
            fluid.setIcons(blockFactoryFluid.func_149691_a(1, 0), blockFactoryFluid.func_149691_a(2, 0));
        } else {
            blockFactoryFluid.setIcons(fluid.getStillIcon(), fluid.getFlowingIcon());
        }
    }

    @SubscribeEvent
    public void clientLoggedIn(FMLNetworkEvent.ClientConnectedToServerEvent clientConnectedToServerEvent) {
        prcPages.clear();
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent playerChangedDimensionEvent) {
        _areaTileEntities.clear();
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.side != Side.CLIENT | playerTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer entityPlayer = playerTickEvent.player;
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemRocketLauncher) {
            Entity entity = this.rayTrace();
            if (this._lastEntityOver != null && this._lastEntityOver.field_70128_L) {
                this._lastEntityOver = null;
                this._lockonTicks = 0;
            } else if ((entity == null || entity != this._lastEntityOver) && this._lockonLostTicks > 0) {
                --this._lockonLostTicks;
            } else if (entity == null && this._lockonLostTicks == 0) {
                if (this._lockonTicks > 0) {
                    --this._lockonTicks;
                }
                this._lastEntityOver = null;
            } else if (this._lastEntityOver == null) {
                this._lastEntityOver = entity;
            } else if (this._lockonTicks < 30) {
                ++this._lockonTicks;
                if (this._lockonTicks >= 30) {
                    this._lockonLostTicks = 60;
                }
            } else if (entity != null && entity == this._lastEntityOver) {
                this._lockonLostTicks = 60;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEnd(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase != TickEvent.Phase.END) {
            return;
        }
        this.renderHUD(renderTickEvent.renderTickTime);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private void renderHUD(float f) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!minecraft.func_147113_T() && minecraft.field_71462_r == null && minecraft.field_71439_g != null && minecraft.field_71439_g.field_71071_by.func_70448_g() != null && minecraft.field_71439_g.field_71071_by.func_70448_g().func_77973_b() instanceof ItemRocketLauncher) {
            ScaledResolution scaledResolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
            Point point = new Point(scaledResolution.func_78326_a() / 2, scaledResolution.func_78328_b() / 2);
            if (instance.getLockedEntity() != Integer.MIN_VALUE) {
                minecraft.field_71446_o.func_110577_a(targetingBlue);
            } else {
                minecraft.field_71446_o.func_110577_a(targetingRed);
            }
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)point.getX(), (float)point.getY(), (float)0.0f);
            GL11.glRotatef((float)((float)((minecraft.field_71441_e.func_82737_E() & 0x1FFL) * 4L % 360L) + f), (float)0.0f, (float)0.0f, (float)1.0f);
            float f2 = instance.getLockTimeRemaining();
            this.drawLockonPart(point, f2, 0);
            this.drawLockonPart(point, f2, 90);
            this.drawLockonPart(point, f2, 180);
            this.drawLockonPart(point, f2, 270);
            GL11.glPopMatrix();
        }
    }

    private void drawLockonPart(Point point, float f, int n) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)n, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-8.0f, (float)-13.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(-f), (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)0, (int)0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2i((int)0, (int)16);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2i((int)16, (int)16);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2i((int)16, (int)0);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void setArmorModel(RenderPlayerEvent.SetArmorModel setArmorModel) {
        ItemStack itemStack = setArmorModel.stack;
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            int n = 3 - setArmorModel.slot;
            if (item == MFRThings.plasticCupItem) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(item.getArmorTexture(itemStack, setArmorModel.entity, n, null)));
                ModelBiped modelBiped = new ModelBiped(1.0f);
                modelBiped.field_78116_c.field_78806_j = n == 0;
                modelBiped.field_78114_d.field_78806_j = n == 0;
                modelBiped.field_78115_e.field_78806_j = n == 1 || n == 2;
                modelBiped.field_78112_f.field_78806_j = n == 1;
                modelBiped.field_78113_g.field_78806_j = n == 1;
                modelBiped.field_78123_h.field_78806_j = n == 2 || n == 3;
                modelBiped.field_78124_i.field_78806_j = n == 2 || n == 3;
                setArmorModel.renderer.func_77042_a((ModelBase)modelBiped);
                modelBiped.field_78095_p = setArmorModel.entityLiving.func_70678_g(setArmorModel.partialRenderTick);
                modelBiped.field_78093_q = setArmorModel.entity.func_70115_ae();
                modelBiped.field_78091_s = setArmorModel.entityLiving.func_70631_g_();
                float f = 1.0f;
                GL11.glColor3f((float)f, (float)f, (float)f);
                if (itemStack.func_77948_v()) {
                    setArmorModel.result = 15;
                    return;
                }
                setArmorModel.result = 1;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderWorldLast(RenderWorldLastEvent renderWorldLastEvent) {
        EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
        if (entityClientPlayerMP.field_71071_by.func_70448_g() == null || !entityClientPlayerMP.field_71071_by.func_70448_g().func_77973_b().equals(MFRThings.factoryHammerItem)) {
            return;
        }
        float f = -((float)(entityClientPlayerMP.field_70142_S + (entityClientPlayerMP.field_70165_t - entityClientPlayerMP.field_70142_S) * (double)renderWorldLastEvent.partialTicks));
        float f2 = -((float)(entityClientPlayerMP.field_70137_T + (entityClientPlayerMP.field_70163_u - entityClientPlayerMP.field_70137_T) * (double)renderWorldLastEvent.partialTicks));
        float f3 = -((float)(entityClientPlayerMP.field_70136_U + (entityClientPlayerMP.field_70161_v - entityClientPlayerMP.field_70136_U) * (double)renderWorldLastEvent.partialTicks));
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7424);
        for (IHarvestAreaContainer iHarvestAreaContainer : _areaTileEntities) {
            if (((TileEntity)iHarvestAreaContainer).func_145837_r()) continue;
            float f4 = this.colorFromCoord(iHarvestAreaContainer.getHAM().getOriginX(), -128821112L);
            float f5 = this.colorFromCoord(iHarvestAreaContainer.getHAM().getOriginY(), -2051162740L);
            float f6 = this.colorFromCoord(iHarvestAreaContainer.getHAM().getOriginZ(), -1720281409L);
            GL11.glPushMatrix();
            GL11.glColor4f((float)f4, (float)f5, (float)f6, (float)0.4f);
            GL11.glTranslatef((float)f, (float)f2, (float)f3);
            MineFactoryReloadedClient.renderAABB(iHarvestAreaContainer.getHAM().getHarvestArea().toAxisAlignedBB());
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
    }

    private float colorFromCoord(int n, long l) {
        l = l * (long)n + 186L;
        l ^= l >>> 20 ^ l >>> 12;
        l ^= l >>> 7 ^ l >>> 4;
        return (float)(l & 0xFFL) / 319.0f + 0.1f;
    }

    public static void addTileToAreaList(IHarvestAreaContainer iHarvestAreaContainer) {
        _areaTileEntities.add(iHarvestAreaContainer);
    }

    public static void removeTileFromAreaList(IHarvestAreaContainer iHarvestAreaContainer) {
        _areaTileEntities.remove(iHarvestAreaContainer);
    }

    public int getLockedEntity() {
        if (this._lastEntityOver != null && this._lockonTicks >= 30) {
            return this._lastEntityOver.func_145782_y();
        }
        return Integer.MIN_VALUE;
    }

    public int getLockTimeRemaining() {
        if (this._lastEntityOver != null && this._lockonTicks >= 30) {
            return 60 - this._lockonLostTicks;
        }
        return (30 - this._lockonTicks) * 2;
    }

    private Entity rayTrace() {
        if (Minecraft.func_71410_x().field_71451_h == null || Minecraft.func_71410_x().field_71441_e == null) {
            return null;
        }
        double d = 64.0;
        Vec3 vec3 = Minecraft.func_71410_x().field_71451_h.func_70666_h(1.0f);
        Vec3 vec32 = Minecraft.func_71410_x().field_71451_h.func_70676_i(1.0f);
        Vec3 vec33 = vec3.func_72441_c(vec32.field_72450_a * d, vec32.field_72448_b * d, vec32.field_72449_c * d);
        List list = Minecraft.func_71410_x().field_71441_e.func_72839_b((Entity)Minecraft.func_71410_x().field_71451_h, Minecraft.func_71410_x().field_71451_h.field_70121_D.func_72321_a(vec32.field_72450_a * d, vec32.field_72448_b * d, vec32.field_72449_c * d).func_72314_b(1.0, 1.0, 1.0));
        double d2 = d;
        Entity entity = null;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity2 = (Entity)list.get(i);
            if (!entity2.func_70067_L()) continue;
            double d4 = entity2.func_70111_Y();
            AxisAlignedBB axisAlignedBB = entity2.field_70121_D.func_72314_b(d4, d4, d4);
            MovingObjectPosition movingObjectPosition = axisAlignedBB.func_72327_a(vec3, vec33);
            if (axisAlignedBB.func_72318_a(vec3)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                entity = entity2;
                d2 = 0.0;
                continue;
            }
            if (movingObjectPosition == null || !((d3 = vec3.func_72438_d(movingObjectPosition.field_72307_f)) < d2) && d2 != 0.0) continue;
            entity = entity2;
            d2 = d3;
        }
        if (entity != null) {
            return entity;
        }
        return null;
    }

    public static void renderAABB(AxisAlignedBB axisAlignedBB) {
        double d = 0.006;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78381_a();
    }

    static {
        targetingBlue = new ResourceLocation("minefactoryreloaded:textures/hud/lockon_blue.png");
        targetingRed = new ResourceLocation("minefactoryreloaded:textures/hud/lockon_red.png");
        gl14 = false;
        prcPages = new HashMap();
        _areaTileEntities = new LinkedHashSet<IHarvestAreaContainer>();
    }
}

