/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.blockiterators;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.blockiterators.AbstractBlockIterator;

public class CubicBlockIterator
extends AbstractBlockIterator {
    protected int radius;
    protected int minX;
    protected int minY;
    protected int minZ;
    protected int curX;
    protected int curY;
    protected int curZ;
    protected int maxX;
    protected int maxY;
    protected int maxZ;

    public CubicBlockIterator(BlockCoord base, int radius) {
        super(base);
        this.radius = radius;
        this.curX = this.minX = base.x - radius;
        this.curY = this.minY = base.y - radius;
        this.curZ = this.minZ = base.z - radius;
        this.maxX = base.x + radius;
        this.maxY = base.y + radius;
        this.maxZ = base.z + radius;
    }

    @Override
    public BlockCoord next() {
        BlockCoord ret = new BlockCoord(this.curX, this.curY, this.curZ);
        int n = this.curX = this.curX == this.maxX ? this.minX : this.curX + 1;
        this.curY = this.curX == this.minX ? (this.curY == this.maxY ? this.minY : this.curY + 1) : this.curY;
        this.curZ = this.curY == this.minY && this.curX == this.minX ? this.curZ + 1 : this.curZ;
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.curZ <= this.maxZ;
    }
}

