/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import openmods.calc.ICalculatorFrame;
import openmods.calc.IExecutable;

public class ExecutableList<E>
implements IExecutable<E> {
    private final List<IExecutable<E>> commands;

    public ExecutableList(List<IExecutable<E>> commands) {
        this.commands = ImmutableList.copyOf(commands);
    }

    public ExecutableList(IExecutable<E> ... commands) {
        this.commands = ImmutableList.copyOf((Object[])commands);
    }

    public List<IExecutable<E>> getCommands() {
        return this.commands;
    }

    @Override
    public void execute(ICalculatorFrame<E> frame) {
        for (IExecutable<E> e : this.commands) {
            e.execute(frame);
        }
    }
}

