/*
 * Decompiled with CFR 0.152.
 */
package openmods.access;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.lang.annotation.Annotation;
import java.util.Set;
import openmods.Log;
import openmods.access.ApiProviderRegistry;
import openmods.reflection.FieldAccess;
import openmods.utils.CachedFactory;

public class ApiFactory {
    public static final ApiFactory instance = new ApiFactory();
    private final CachedFactory<String, Class<?>> clsCache = new CachedFactory<String, Class<?>>(){

        @Override
        protected Class<?> create(String className) {
            try {
                return Class.forName(className, true, this.getClass().getClassLoader());
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
    };
    private final Set<Class<? extends Annotation>> apis = Sets.newHashSet();

    private <A> void fillTargetField(ApiProviderRegistry<A> registry, ASMDataTable.ASMData data, Class<A> interfaceMarker) {
        String targetClassName = data.getClassName();
        String targetFieldName = data.getObjectName();
        Class<?> targetCls = this.clsCache.getOrCreate(targetClassName);
        FieldAccess field = FieldAccess.create(targetCls, targetFieldName);
        Class type = field.getType();
        Preconditions.checkState((boolean)field.isStatic(), (String)"Failed to set API field on %s:%s - field must be static", (Object[])new Object[]{targetClassName, targetFieldName});
        Preconditions.checkState((!field.isFinal() ? 1 : 0) != 0, (String)"Failed to set API field on %s:%s - field must not be final", (Object[])new Object[]{targetClassName, targetFieldName});
        Preconditions.checkState((boolean)interfaceMarker.isAssignableFrom(type), (String)"Failed to set API field on %s:%s - invalid type, expected %s", (Object[])new Object[]{targetClassName, targetFieldName, interfaceMarker});
        FieldAccess<A> castedField = field.cast(interfaceMarker);
        A api = registry.getApi(castedField.getType());
        if (api != null) {
            castedField.set(null, api);
            Log.trace("Injecting instance of %s from mod %s to field %s:%s from file %s", type, Loader.instance().activeModContainer().getModId(), targetClassName, targetFieldName, data.getCandidate().getModContainer());
        } else {
            Log.info("Can't set API field %s:%s - no API for type %s", targetClassName, targetFieldName, castedField.getType());
        }
    }

    private <A> void fillTargetFields(ApiProviderRegistry<A> registry, ASMDataTable table, Class<? extends Annotation> fieldMarker, Class<A> interfaceMarker) {
        Set targets = table.getAll(fieldMarker.getName());
        for (ASMDataTable.ASMData data : targets) {
            this.fillTargetField(registry, data, interfaceMarker);
        }
    }

    public <A> ApiProviderRegistry<A> createApi(Class<? extends Annotation> fieldMarker, Class<A> interfaceMarker, ASMDataTable table, ApiProviderSetup<A> registrySetup) {
        Preconditions.checkState((boolean)this.apis.add(fieldMarker), (String)"Duplicate API registration on %s", (Object[])new Object[]{fieldMarker});
        ApiProviderRegistry<A> registry = new ApiProviderRegistry<A>(interfaceMarker);
        registrySetup.setup(registry);
        registry.freeze();
        this.fillTargetFields(registry, table, fieldMarker, interfaceMarker);
        return registry;
    }

    public <A> void createApi(Class<? extends Annotation> fieldMarker, Class<A> interfaceMarker, ASMDataTable table, ApiProviderRegistry<A> registry) {
        Preconditions.checkState((boolean)this.apis.add(fieldMarker), (String)"Duplicate API registration on %s", (Object[])new Object[]{fieldMarker});
        Preconditions.checkState((boolean)registry.isFrozen(), (Object)"Registry must be frozen");
        this.fillTargetFields(registry, table, fieldMarker, interfaceMarker);
    }

    public static interface ApiProviderSetup<A> {
        public void setup(ApiProviderRegistry<A> var1);
    }
}

