/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cpw.mods.fml.common.IWorldGenerator;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.MetaBlock;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.DeployableStructure;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.config.structures.StructureManager;
import cr0s.warpdrive.world.WorldGenSmallShip;
import cr0s.warpdrive.world.WorldGenStation;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class SpaceWorldGenerator
implements IWorldGenerator {
    public final int MOON_RADIUS = 32;
    public final int MOON_CORE_RADIUS = 10;
    public final int RED_DWARF_RADIUS = 42;
    public final int YELLOW_GIANT_RADIUS = 64;
    public final int YELLOW_SUPERGIANT_RADIUS = 80;
    public static int Y_LIMIT_HARD_MAX = 200;
    public static int Y_LIMIT_SOFT_MAX = 128;
    public static int Y_LIMIT_SOFT_MIN = 55;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        try {
            if (world.field_73011_w.field_76574_g != WarpDriveConfig.G_SPACE_DIMENSION_ID) {
                return;
            }
            int x = chunkX * 16 + (5 - random.nextInt(10));
            int z = chunkZ * 16 + (5 - random.nextInt(10));
            if (WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS > 0 && (Math.abs(x) > WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS || Math.abs(z) > WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS)) {
                return;
            }
            int y = Y_LIMIT_SOFT_MIN + random.nextInt(Y_LIMIT_SOFT_MAX - Y_LIMIT_SOFT_MIN);
            if (random.nextInt(700) == 1) {
                SpaceWorldGenerator.generateMoon(world, x, y, z, null);
            } else if (random.nextInt(150) == 1) {
                SpaceWorldGenerator.generateRandomAsteroid(world, x, y, z);
            } else if (random.nextInt(500) == 1) {
                SpaceWorldGenerator.generateAsteroidField(world, x, y, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateMoon(World world, int x, int y, int z, String moonName) {
        DeployableStructure moon = StructureManager.getMoon(world.field_73012_v, moonName);
        WarpDrive.logger.info("Generating moon (class " + (Object)((Object)moon) + ") at " + x + " " + y + " " + z);
        moon.func_76484_a(world, world.field_73012_v, x, y, z);
    }

    public void generateStar(World world, int x, int y, int z, String starName) {
        DeployableStructure star = StructureManager.getStar(world.field_73012_v, starName);
        WarpDrive.logger.info("Generating star (class " + (Object)((Object)star) + ") at " + x + " " + y + " " + z);
        star.func_76484_a(world, world.field_73012_v, x, y, z);
    }

    private static void generateSmallShip(World world, int x, int y, int z, int jitter) {
        int x2 = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int y2 = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int z2 = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        WarpDrive.logger.info("Generating small ship at " + x2 + "," + y2 + "," + z2);
        new WorldGenSmallShip(world.field_73012_v.nextBoolean()).func_76484_a(world, world.field_73012_v, x2, y2, z2);
    }

    private static void generateStation(World world, int x, int y, int z, int jitter) {
        int x2 = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int y2 = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        int z2 = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(jitter);
        WarpDrive.logger.info("Generating small ship at " + x2 + "," + y2 + "," + z2);
        new WorldGenStation(world.field_73012_v.nextBoolean()).generate(world, world.field_73012_v, x2, y2, z2);
    }

    private static float binomialRandom(World world) {
        float linear = world.field_73012_v.nextFloat();
        return 1.25f - 0.625f / (0.5f + 2.0f * linear);
    }

    public static void generateAsteroidField(World world, int x, int y1, int z) {
        int aZ;
        int aY;
        int aX;
        float verticalRange;
        float horizontalRange;
        double yawn;
        double bearing;
        float binomial;
        int i;
        LocalProfiler.start("SpaceWorldGenerator.generateAsteroidField");
        float surfacePerAsteroid = 80.0f + world.field_73012_v.nextFloat() * 300.0f;
        int maxDistance = 30 + world.field_73012_v.nextInt(170);
        int maxDistanceBig = Math.round((float)maxDistance * (0.6f + 0.2f * world.field_73012_v.nextFloat()));
        int maxDistanceSmall = Math.round((float)maxDistance * 1.1f);
        float bigRatio = 0.3f + world.field_73012_v.nextFloat() * 0.3f;
        float surfaceBig = (float)(Math.PI * Math.pow(maxDistanceBig, 2.0));
        float surfaceSmall = (float)(Math.PI * Math.pow(maxDistanceSmall, 2.0));
        int numOfBigAsteroids = Math.round(bigRatio * surfaceBig / surfacePerAsteroid);
        int numOfSmallAsteroids = Math.round((1.0f - bigRatio) * surfaceSmall / surfacePerAsteroid);
        int numOfClouds = Math.round((float)numOfBigAsteroids * 1.0f / (10.0f + (float)world.field_73012_v.nextInt(10)));
        int maxHeight = 70 + world.field_73012_v.nextInt(50);
        int y2 = Math.min(Y_LIMIT_HARD_MAX - maxHeight, Math.max(y1, maxHeight));
        WarpDrive.logger.info("Generating asteroid field at " + x + "," + y2 + "," + z + " qty " + numOfBigAsteroids + ", " + numOfSmallAsteroids + ", " + numOfClouds + " over " + maxDistance + ", " + maxHeight + " surfacePerAsteroid " + String.format("%.1f", Float.valueOf(surfacePerAsteroid)));
        for (i = 1; i <= numOfBigAsteroids; ++i) {
            binomial = SpaceWorldGenerator.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceBig);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (WarpDriveConfig.LOGGING_WORLDGEN) {
                WarpDrive.logger.info(String.format("Big asteroid: %.3f %.3f r %.3f r makes %3d, %3d, %3d", binomial, bearing, yawn, aX, aY, aZ));
            }
            SpaceWorldGenerator.generateRandomAsteroid(world, aX, aY, aZ);
        }
        for (i = 1; i <= numOfSmallAsteroids; ++i) {
            binomial = SpaceWorldGenerator.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceSmall);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (world.field_73012_v.nextInt(400) != 1) {
                SpaceWorldGenerator.generateRandomAsteroid(world, aX, aY, aZ);
                continue;
            }
            if (world.field_73012_v.nextInt(20) != 1) {
                SpaceWorldGenerator.generateSmallShip(world, aX, aY, aZ, 8);
                continue;
            }
            SpaceWorldGenerator.generateStation(world, aX, aY, aZ, 8);
        }
        for (i = 1; i <= numOfClouds; ++i) {
            binomial = SpaceWorldGenerator.binomialRandom(world);
            bearing = (double)world.field_73012_v.nextFloat() * 2.0 * Math.PI;
            yawn = (double)world.field_73012_v.nextFloat() * Math.PI;
            horizontalRange = Math.max(6.0f, binomial * (float)maxDistanceBig);
            verticalRange = Math.max(3.0f, binomial * (float)maxHeight);
            aX = (int)((long)x + Math.round((double)horizontalRange * Math.cos(bearing)));
            aY = (int)((long)y2 + Math.round((double)verticalRange * Math.cos(yawn)));
            aZ = (int)((long)z + Math.round((double)horizontalRange * Math.sin(bearing)));
            if (!world.field_73012_v.nextBoolean()) continue;
            SpaceWorldGenerator.generateGasCloudOfColor(world, aX, aY, aZ, 12, 15, null);
        }
        LocalProfiler.stop();
    }

    public static void generateGasCloudOfColor(World world, int x, int y, int z, int cloudSizeMax, int centerRadiusMax, String type) {
        int cloudSize = 1 + world.field_73012_v.nextInt(20);
        if (cloudSizeMax != 0) {
            cloudSize = Math.min(cloudSizeMax, cloudSize);
        }
        int centerRadius = 1 + world.field_73012_v.nextInt(20);
        if (centerRadiusMax != 0) {
            centerRadius = Math.min(centerRadiusMax, centerRadius);
        }
        int CENTER_SHIFT = 2;
        DeployableStructure cloud = StructureManager.getGasCloud(world.field_73012_v, type);
        if (cloud == null) {
            WarpDrive.logger.error("No gaz cloud defined, cancelling world generation");
            return;
        }
        for (int i = 1; i <= cloudSize; ++i) {
            int radius = 2 + world.field_73012_v.nextInt(centerRadius);
            int newX = x + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(2 + centerRadius / 2);
            int newY = y + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(2 + centerRadius / 2);
            int newZ = z + (world.field_73012_v.nextBoolean() ? -1 : 1) * world.field_73012_v.nextInt(2 + centerRadius / 2);
            ((Orb)cloud).generate(world, world.field_73012_v, newX, newY, newZ, radius);
        }
    }

    public static void generateRandomAsteroid(World world, int x, int y, int z) {
        DeployableStructure asteroid = StructureManager.getAsteroid(world.field_73012_v, null);
        WarpDrive.logger.info("Generating asteroid (class " + (Object)((Object)asteroid) + ") at " + x + " " + y + " " + z);
        asteroid.func_76484_a(world, world.field_73012_v, x, y, z);
    }

    public static void generateSphereDirect(World world, int xCoord, int yCoord, int zCoord, Orb orb, Random rand) {
        double radiusC = (double)(orb.getHeight() / 2) + 0.5;
        double radiusSq = radiusC * radiusC;
        int ceilRadius = (int)Math.ceil(radiusC);
        for (int x = 0; x <= ceilRadius; ++x) {
            double x2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = 0; y <= ceilRadius; ++y) {
                double y2 = ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = 0; z <= ceilRadius; ++z) {
                    double z2 = ((double)z + 0.5) * ((double)z + 0.5);
                    int dSq = (int)Math.sqrt(x2 + y2 + z2);
                    if ((double)dSq > radiusSq) continue;
                    Orb.OrbShell orbShell = orb.getShellForRadius(dSq);
                    MetaBlock metablock = orbShell.getRandomBlock(rand);
                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord - x, yCoord + y, zCoord + z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord + x, yCoord - y, zCoord + z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord + x, yCoord + y, zCoord - z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord - x, yCoord - y, zCoord + z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord + x, yCoord - y, zCoord - z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord - x, yCoord + y, zCoord - z, metablock.block, metablock.metadata, 2);
                    world.func_147465_d(xCoord - x, yCoord - y, zCoord - z, metablock.block, metablock.metadata, 2);
                }
            }
        }
    }
}

