/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cpw.mods.fml.common.FMLCommonHandler;
import cr0s.warpdrive.WarpDrive;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public final class EntityStarCore
extends Entity {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    private int radius;
    private final int KILL_RADIUS = 60;
    private final int BURN_RADIUS = 200;
    private boolean isLogged = false;
    private final int ENTITY_ACTION_INTERVAL = 10;
    private int ticks = 0;

    public EntityStarCore(World world) {
        super(world);
    }

    public EntityStarCore(World world, int x, int y, int z, int radius) {
        super(world);
        this.xCoord = x;
        this.field_70165_t = x;
        this.yCoord = y;
        this.field_70163_u = y;
        this.zCoord = z;
        this.field_70161_v = z;
        this.radius = radius;
    }

    private void actionToEntitiesNearStar() {
        int MAX_RANGE = this.radius + 60 + 200;
        int KILL_RANGESQ = (this.radius + 60) * (this.radius + 60);
        int BURN_RANGESQ = (this.radius + 60 + 200) * (this.radius + 60 + 200);
        int xmin = this.xCoord - MAX_RANGE;
        int xmax = this.xCoord + MAX_RANGE;
        int zmin = this.zCoord - MAX_RANGE;
        int zmax = this.zCoord + MAX_RANGE;
        int ymin = this.yCoord - MAX_RANGE;
        int ymax = this.yCoord + MAX_RANGE;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)xmin, (double)ymin, (double)zmin, (double)xmax, (double)ymax, (double)zmax);
        List list = this.field_70170_p.func_72839_b((Entity)this, aabb);
        if (!this.isLogged) {
            this.isLogged = true;
            WarpDrive.logger.info((Object)((Object)this) + " Capture range " + MAX_RANGE + " X " + xmin + " to " + xmax + " Y " + ymin + " to " + ymax + " Z " + zmin + " to " + zmax);
        }
        for (Object o : list) {
            if (o == null || !(o instanceof Entity) || !(o instanceof EntityLivingBase)) continue;
            EntityLivingBase entity = (EntityLivingBase)o;
            if (entity.func_70068_e((Entity)this) <= (double)KILL_RANGESQ) {
                entity.func_70097_a(DamageSource.field_76370_b, 9000.0f);
                continue;
            }
            if (!(entity.func_70068_e((Entity)this) <= (double)BURN_RANGESQ)) continue;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71075_bZ.field_75098_d) continue;
            }
            if (!entity.func_70045_F()) {
                entity.func_70015_d(100);
            }
            entity.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
    }

    public void killEntity() {
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public void func_70071_h_() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (++this.ticks > 10) {
            this.ticks = 0;
            this.actionToEntitiesNearStar();
        }
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.xCoord = nbttagcompound.func_74762_e("x");
        this.yCoord = nbttagcompound.func_74762_e("y");
        this.zCoord = nbttagcompound.func_74762_e("z");
        this.radius = nbttagcompound.func_74762_e("radius");
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("x", this.xCoord);
        nbttagcompound.func_74768_a("y", this.yCoord);
        nbttagcompound.func_74768_a("z", this.zCoord);
        nbttagcompound.func_74768_a("radius", this.radius);
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

