/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cpw.mods.fml.common.FMLCommonHandler;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.MetaBlock;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.data.JumpBlock;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class EntitySphereGen
extends Entity {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    private int radius;
    private int gasColor;
    private final int BLOCKS_PER_TICK = 5000;
    private final int STATE_SAVING = 0;
    private final int STATE_SETUP = 1;
    private final int STATE_DELETE = 2;
    private final int STATE_STOP = 3;
    private int state = 2;
    private int ticksDelay = 0;
    private int currentIndex = 0;
    private int pregenSize = 0;
    private ArrayList<JumpBlock> blocks;
    private Orb orb;
    private boolean replace;

    public EntitySphereGen(World world) {
        super(world);
    }

    public EntitySphereGen(World world, int x, int y, int z, int radius, Orb orb, boolean replace) {
        super(world);
        this.xCoord = x;
        this.field_70165_t = x;
        this.yCoord = y;
        this.field_70163_u = y;
        this.zCoord = z;
        this.field_70161_v = z;
        this.gasColor = this.field_70170_p.field_73012_v.nextInt(12);
        this.radius = radius;
        this.state = 0;
        this.pregenSize = (int)Math.ceil(4.1887902047863905 * Math.pow(radius + 1, 3.0));
        this.blocks = new ArrayList(this.pregenSize);
        this.ticksDelay = world.field_73012_v.nextInt(60);
        this.orb = orb;
        this.replace = replace;
    }

    public void killEntity() {
        this.state = 3;
        this.field_70170_p.func_147458_c(this.xCoord - this.radius, this.yCoord - this.radius, this.zCoord - this.radius, this.xCoord + this.radius, this.yCoord + this.radius, this.zCoord + this.radius);
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public void func_70071_h_() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.ticksDelay > 0) {
            --this.ticksDelay;
            return;
        }
        switch (this.state) {
            case 0: {
                this.tickScheduleBlocks();
                this.state = 1;
                break;
            }
            case 1: {
                if (this.currentIndex >= this.blocks.size() - 1) {
                    this.state = 2;
                    break;
                }
                this.tickPlaceBlocks();
                break;
            }
            case 2: {
                this.currentIndex = 0;
                this.killEntity();
                break;
            }
            default: {
                WarpDrive.logger.error((Object)((Object)this) + " Invalid state " + this.state + ". Killing entity...");
                this.killEntity();
            }
        }
    }

    private void tickPlaceBlocks() {
        int blocksToMove = Math.min(5000, this.blocks.size() - this.currentIndex);
        LocalProfiler.start("[EntitySphereGen] Placing blocks from " + this.currentIndex + " to " + (this.currentIndex + blocksToMove) + "/" + this.blocks.size());
        for (int index = 0; index < blocksToMove && this.currentIndex < this.blocks.size(); ++index) {
            int notifyFlag = this.currentIndex % 1000 == 0 ? 2 : 2;
            JumpBlock jb = this.blocks.get(this.currentIndex);
            JumpBlock.setBlockNoLight(this.field_70170_p, jb.x, jb.y, jb.z, jb.block, jb.blockMeta, notifyFlag);
            ++this.currentIndex;
        }
        LocalProfiler.stop();
    }

    private void tickScheduleBlocks() {
        LocalProfiler.start("[EntitySphereGen] Saving blocks");
        this.radius = (int)((double)this.radius + 0.5);
        int ceilRadius = (int)Math.ceil(this.radius);
        for (int x = 0; x <= ceilRadius; ++x) {
            double x2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = 0; y <= ceilRadius; ++y) {
                double y2 = ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = 0; z <= ceilRadius; ++z) {
                    double z2 = ((double)z + 0.5) * ((double)z + 0.5);
                    double dSq = Math.sqrt(x2 + y2 + z2);
                    if (dSq > (double)this.radius) continue;
                    int rad = (int)Math.ceil(dSq);
                    Orb.OrbShell orbShell = this.orb.getShellForRadius(rad);
                    MetaBlock metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord + x, this.yCoord + y, this.zCoord + z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord - x, this.yCoord + y, this.zCoord + z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord + x, this.yCoord - y, this.zCoord + z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord + x, this.yCoord + y, this.zCoord - z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord - x, this.yCoord - y, this.zCoord + z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord + x, this.yCoord - y, this.zCoord - z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord - x, this.yCoord + y, this.zCoord - z));
                    metablock = orbShell.getRandomBlock(this.field_70146_Z);
                    this.addBlock(new JumpBlock(metablock.block, metablock.metadata, this.xCoord - x, this.yCoord - y, this.zCoord - z));
                }
            }
        }
        if (this.blocks != null) {
            WarpDrive.logger.info("[EntitySphereGen] Saved " + this.blocks.size() + " blocks (estimated to " + this.pregenSize + ")");
        }
        LocalProfiler.stop();
    }

    private void addBlock(JumpBlock jb) {
        if (this.blocks == null) {
            return;
        }
        if (this.field_70170_p.func_147439_a(jb.x, jb.y, jb.z).func_149667_c(Blocks.field_150355_j)) {
            if (this.field_70170_p.field_73012_v.nextInt(50) != 1) {
                jb.block = WarpDrive.blockGas;
                jb.blockMeta = this.gasColor;
            }
            this.blocks.add(jb);
            return;
        }
        if (!this.replace && !this.field_70170_p.func_147437_c(jb.x, jb.y, jb.z)) {
            return;
        }
        this.blocks.add(jb);
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70088_a() {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

