/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.render.ClientCameraHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderOverlayCamera {
    private Minecraft mc;
    private int frameCount = 0;
    private static int ANIMATION_FRAMES = 200;

    public RenderOverlayCamera(Minecraft parMinecraft) {
        this.mc = parMinecraft;
    }

    private static int colorGradient(float gradient, int start, int end) {
        return Math.max(0, Math.min(255, start + Math.round(gradient * (float)(end - start))));
    }

    protected void renderOverlay(int scaledWidth, int scaledHeight) {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        try {
            String strHelp;
            if (ClientCameraHandler.overlayType == 0) {
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("warpdrive", "textures/blocks/detection/cameraOverlay.png"));
                strHelp = "Left click to zoom / Right click to exit";
            } else {
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("warpdrive", "textures/blocks/weapon/laserCameraOverlay.png"));
                strHelp = "Left click to zoom / Right click to exit / Space to fire";
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a(0.0, (double)scaledHeight, -90.0, 0.0, 1.0);
            tessellator.func_78374_a((double)scaledWidth, (double)scaledHeight, -90.0, 1.0, 1.0);
            tessellator.func_78374_a((double)scaledWidth, 0.0, -90.0, 1.0, 0.0);
            tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
            tessellator.func_78381_a();
            ++this.frameCount;
            if (this.frameCount >= ANIMATION_FRAMES) {
                this.frameCount = 0;
            }
            float time = Math.abs((float)this.frameCount * 2.0f / (float)ANIMATION_FRAMES - 1.0f);
            int color = (RenderOverlayCamera.colorGradient(time, 64, 160) << 16) + (RenderOverlayCamera.colorGradient(time, 128, 0) << 8) + RenderOverlayCamera.colorGradient(time, 128, 255);
            this.mc.field_71466_p.func_85187_a(strHelp, (scaledWidth - this.mc.field_71466_p.func_78256_a(strHelp)) / 2, (int)((double)scaledHeight * 0.19) - this.mc.field_71466_p.field_78288_b, color, true);
            String strZoom = "Zoom " + ClientCameraHandler.originalFOV / this.mc.field_71474_y.field_74334_X + "x";
            this.mc.field_71466_p.func_85187_a(strZoom, (int)((double)scaledWidth * 0.91) - this.mc.field_71466_p.func_78256_a(strZoom), (int)((double)scaledHeight * 0.81), 4235392, true);
            if (WarpDriveConfig.LOGGING_CAMERA) {
                this.mc.field_71466_p.func_85187_a(ClientCameraHandler.overlayLoggingMessage, (scaledWidth - this.mc.field_71466_p.func_78256_a(ClientCameraHandler.overlayLoggingMessage)) / 2, (int)((double)scaledHeight * 0.19), 0xFF008F, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (ClientCameraHandler.isOverlayEnabled) {
            if (event.type == RenderGameOverlayEvent.ElementType.HELMET) {
                this.renderOverlay(event.resolution.func_78326_a(), event.resolution.func_78328_b());
            } else if ((event.type == RenderGameOverlayEvent.ElementType.AIR || event.type == RenderGameOverlayEvent.ElementType.ARMOR || event.type == RenderGameOverlayEvent.ElementType.BOSSHEALTH || event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS || event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.type == RenderGameOverlayEvent.ElementType.FOOD || event.type == RenderGameOverlayEvent.ElementType.HEALTH || event.type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT || event.type == RenderGameOverlayEvent.ElementType.HOTBAR || event.type == RenderGameOverlayEvent.ElementType.TEXT) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }
}

