/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.MessageBeamEffect;
import cr0s.warpdrive.network.MessageCloak;
import cr0s.warpdrive.network.MessageFrequency;
import cr0s.warpdrive.network.MessageTargeting;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class PacketHandler {
    public static final SimpleNetworkWrapper simpleNetworkManager = NetworkRegistry.INSTANCE.newSimpleChannel("WarpDrive");
    private static Method EntityTrackerEntry_getPacketForThisEntity;

    public static void init() {
        simpleNetworkManager.registerMessage(MessageBeamEffect.class, MessageBeamEffect.class, 0, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageFrequency.class, MessageFrequency.class, 1, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageCloak.class, MessageCloak.class, 2, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageTargeting.class, MessageTargeting.class, 100, Side.SERVER);
        try {
            EntityTrackerEntry_getPacketForThisEntity = Class.forName("net.minecraft.entity.EntityTrackerEntry").getDeclaredMethod("func_151260_c", new Class[0]);
            EntityTrackerEntry_getPacketForThisEntity.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendBeamPacket(World worldObj, Vector3 source, Vector3 target, float red, float green, float blue, int age, int energy, int radius) {
        assert (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER);
        MessageBeamEffect beamMessage = new MessageBeamEffect(source, target, red, green, blue, age, energy);
        if (source.distanceTo_square(target) < 3600.0) {
            simpleNetworkManager.sendToAllAround((IMessage)beamMessage, new NetworkRegistry.TargetPoint(worldObj.field_73011_w.field_76574_g, (source.x + target.x) / 2.0, (source.y + target.y) / 2.0, (source.z + target.z) / 2.0, (double)radius));
        } else {
            List playerEntityList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            int dimensionId = worldObj.field_73011_w.field_76574_g;
            int radius_square = radius * radius;
            for (int index = 0; index < playerEntityList.size(); ++index) {
                Vector3 player;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)playerEntityList.get(index);
                if (entityplayermp.field_71093_bK != dimensionId || !(source.distanceTo_square(player = new Vector3((Entity)entityplayermp)) < (double)radius_square) && !(target.distanceTo_square(player) < (double)radius_square)) continue;
                simpleNetworkManager.sendTo((IMessage)beamMessage, entityplayermp);
            }
        }
    }

    public static void sendBeamPacketToPlayersInArea(World worldObj, Vector3 source, Vector3 target, float red, float green, float blue, int age, int energy, AxisAlignedBB aabb) {
        assert (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER);
        MessageBeamEffect beamMessage = new MessageBeamEffect(source, target, red, green, blue, age, energy);
        List list = worldObj.func_72872_a(EntityPlayerMP.class, aabb);
        for (Entity entity : list) {
            if (entity == null || !(entity instanceof EntityPlayerMP)) continue;
            simpleNetworkManager.sendTo((IMessage)beamMessage, (EntityPlayerMP)entity);
        }
    }

    public static void sendFreqPacket(int dimensionId, int xCoord, int yCoord, int zCoord, int frequency) {
        MessageFrequency frequencyMessage = new MessageFrequency(xCoord, yCoord, zCoord, frequency);
        simpleNetworkManager.sendToAllAround((IMessage)frequencyMessage, new NetworkRegistry.TargetPoint(dimensionId, (double)xCoord, (double)yCoord, (double)zCoord, 100.0));
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info("Sent frequency packet (" + xCoord + ", " + yCoord + ", " + zCoord + ") frequency " + frequency);
        }
    }

    public static void sendLaserTargetingPacket(int x, int y, int z, float yaw, float pitch) {
        MessageTargeting targetingMessage = new MessageTargeting(x, y, z, yaw, pitch);
        simpleNetworkManager.sendToServer((IMessage)targetingMessage);
        if (WarpDriveConfig.LOGGING_TARGETTING) {
            WarpDrive.logger.info("Sent targeting packet (" + x + ", " + y + ", " + z + ") yaw " + yaw + " pitch " + pitch);
        }
    }

    public static void sendCloakPacket(EntityPlayer player, CloakedArea area, boolean decloak) {
        MessageCloak cloakMessage = new MessageCloak(area, decloak);
        simpleNetworkManager.sendTo((IMessage)cloakMessage, (EntityPlayerMP)player);
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info("Sent cloak packet (area " + area + " decloak " + decloak + ")");
        }
    }

    public static Packet getPacketForThisEntity(Entity entity) {
        EntityTrackerEntry entry = new EntityTrackerEntry(entity, 0, 0, false);
        try {
            return (Packet)EntityTrackerEntry_getPacketForThisEntity.invoke((Object)entry, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

