/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityLaser;
import cr0s.warpdrive.block.detection.TileEntityCamera;
import cr0s.warpdrive.block.detection.TileEntityMonitor;
import cr0s.warpdrive.config.WarpDriveConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MessageFrequency
implements IMessage,
IMessageHandler<MessageFrequency, IMessage> {
    private int x;
    private int y;
    private int z;
    private int frequency;

    public MessageFrequency() {
    }

    public MessageFrequency(int x, int y, int z, int frequency) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.frequency = frequency;
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.frequency = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.frequency);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World worldObj) {
        TileEntity tileEntity = worldObj.func_147438_o(this.x, this.y, this.z);
        if (tileEntity != null) {
            if (tileEntity instanceof TileEntityMonitor) {
                ((TileEntityMonitor)tileEntity).setVideoChannel(this.frequency);
            } else if (tileEntity instanceof TileEntityCamera) {
                ((TileEntityCamera)tileEntity).setVideoChannel(this.frequency);
            } else if (tileEntity instanceof TileEntityLaser) {
                ((TileEntityLaser)tileEntity).setVideoChannel(this.frequency);
            } else {
                WarpDrive.logger.error("Received frequency packet: (" + this.x + ", " + this.y + ", " + this.z + ") is not a valid tile entity");
            }
        } else {
            WarpDrive.logger.error("Received frequency packet: (" + this.x + ", " + this.y + ", " + this.z + ") has no tile entity");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageFrequency frequencyMessage, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring frequency packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info("Received frequency packet: (" + frequencyMessage.x + ", " + frequencyMessage.y + ", " + frequencyMessage.z + ") frequency '" + frequencyMessage.frequency + "'");
        }
        frequencyMessage.handle((World)Minecraft.func_71410_x().field_71441_e);
        return null;
    }
}

